/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.net;

import com.ghgande.j2mod.modbus.ModbusCoupler;
import com.ghgande.j2mod.modbus.ModbusIOException;
import com.ghgande.j2mod.modbus.io.ModbusTransport;
import com.ghgande.j2mod.modbus.msg.ModbusRequest;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.net.ModbusListener;
import com.ghgande.j2mod.modbus.net.SerialConnection;
import com.ghgande.j2mod.modbus.util.SerialParameters;

public class ModbusSerialListener
implements ModbusListener {
    private boolean m_Listening;
    private boolean m_Running = true;
    private SerialConnection m_SerialCon;
    private int m_Unit = 0;

    @Override
    public void run() {
        try {
            try {
                this.m_Listening = true;
                this.m_SerialCon.open();
                ModbusTransport transport = this.m_SerialCon.getModbusTransport();
                while (this.m_Running) {
                    if (this.m_Listening) {
                        try {
                            ModbusRequest request = transport.readRequest();
                            if (request == null || this.m_Unit != 0 && this.m_Unit != request.getUnitID()) continue;
                            ModbusResponse response = null;
                            response = ModbusCoupler.getReference().getProcessImage() == null ? request.createExceptionResponse(1) : request.createResponse();
                            try {
                                System.out.println("Request (" + request.getClass().getName() + "): " + request.getHexMessage());
                                System.out.println("Response (" + response.getClass().getName() + "): " + response.getHexMessage());
                            }
                            catch (RuntimeException runtimeException) {
                                // empty catch block
                            }
                            transport.writeMessage(response);
                        }
                        catch (ModbusIOException ex) {
                            ex.printStackTrace();
                        }
                        continue;
                    }
                    transport.readRequest();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.m_Listening = false;
                if (this.m_SerialCon != null) {
                    this.m_SerialCon.close();
                }
            }
        }
        finally {
            this.m_Listening = false;
            if (this.m_SerialCon != null) {
                this.m_SerialCon.close();
            }
        }
    }

    @Override
    public void setUnit(int unit) {
        this.m_Unit = unit;
    }

    @Override
    public int getUnit() {
        return this.m_Unit;
    }

    @Override
    public void setListening(boolean b) {
        this.m_Listening = b;
    }

    @Override
    public boolean isListening() {
        return this.m_Listening;
    }

    @Override
    public void stop() {
        this.m_Listening = false;
        this.m_Running = false;
    }

    @Override
    public Thread listen() {
        this.m_Listening = true;
        Thread result = new Thread(this);
        result.start();
        return result;
    }

    public ModbusSerialListener(SerialParameters params) {
        this.m_SerialCon = new SerialConnection(params);
    }
}

