/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.net;

import com.ghgande.j2mod.modbus.net.ModbusListener;
import com.ghgande.j2mod.modbus.net.TCPConnectionHandler;
import com.ghgande.j2mod.modbus.net.TCPSlaveConnection;
import com.ghgande.j2mod.modbus.util.ThreadPool;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;

public class ModbusTCPListener
implements ModbusListener {
    private ServerSocket m_ServerSocket = null;
    private ThreadPool m_ThreadPool;
    private Thread m_Listener;
    private int m_Port = 502;
    private int m_Unit = 0;
    private int m_FloodProtection = 5;
    private boolean m_Listening;
    private InetAddress m_Address;

    public void setPort(int port) {
        this.m_Port = port;
    }

    @Override
    public int getUnit() {
        return this.m_Unit;
    }

    @Override
    public void setUnit(int unit) {
        this.m_Unit = unit;
    }

    public void setAddress(InetAddress addr) {
        this.m_Address = addr;
    }

    public void start() {
        this.m_Listening = true;
        this.m_Listener = new Thread(this);
        this.m_Listener.start();
    }

    @Override
    public void stop() {
        this.m_Listening = false;
        try {
            this.m_ServerSocket.close();
            this.m_Listener.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        try {
            this.m_ServerSocket = new ServerSocket(this.m_Port, this.m_FloodProtection, this.m_Address);
            System.out.println("Listenening to " + this.m_ServerSocket.toString() + "(Port " + this.m_Port + ")");
            this.m_Listening = true;
            while (this.m_Listening) {
                Socket incoming = this.m_ServerSocket.accept();
                System.out.println("Making new connection " + incoming.toString());
                if (this.m_Listening) {
                    this.m_ThreadPool.execute(new TCPConnectionHandler(new TCPSlaveConnection(incoming)));
                    continue;
                }
                incoming.close();
            }
        }
        catch (SocketException iex) {
            if (!this.m_Listening) {
                return;
            }
            iex.printStackTrace();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void setListening(boolean b) {
        this.m_Listening = b;
    }

    @Override
    public boolean isListening() {
        return this.m_Listening;
    }

    @Override
    public Thread listen() {
        this.m_Listening = true;
        Thread result = new Thread(this);
        result.start();
        return result;
    }

    public ModbusTCPListener(int poolsize, InetAddress addr) {
        this.m_ThreadPool = new ThreadPool(poolsize);
        this.m_Address = addr;
    }

    public ModbusTCPListener(int poolsize) {
        this.m_ThreadPool = new ThreadPool(poolsize);
        try {
            this.m_Address = InetAddress.getByAddress(new byte[4]);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }
}

