/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.net;

import com.ghgande.j2mod.modbus.ModbusCoupler;
import com.ghgande.j2mod.modbus.ModbusIOException;
import com.ghgande.j2mod.modbus.io.ModbusTransport;
import com.ghgande.j2mod.modbus.io.ModbusUDPTransport;
import com.ghgande.j2mod.modbus.msg.ModbusRequest;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.net.ModbusListener;
import com.ghgande.j2mod.modbus.net.UDPSlaveTerminal;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ModbusUDPListener
implements ModbusListener {
    private int m_Port = 502;
    private boolean m_Listening = false;
    private boolean m_Continue = false;
    private InetAddress m_Interface;
    private UDPSlaveTerminal m_Terminal;
    private ModbusTransport m_Transport;
    private int m_Unit = 0;

    @Override
    public int getUnit() {
        return this.m_Unit;
    }

    @Override
    public void setUnit(int unit) {
        this.m_Unit = unit;
    }

    public int getPort() {
        return this.m_Port;
    }

    public void setPort(int port) {
        this.m_Port = port > 0 ? port : 502;
    }

    @Override
    public void run() {
        try {
            this.m_Terminal = this.m_Interface == null ? new UDPSlaveTerminal(InetAddress.getByName("0.0.0.0")) : new UDPSlaveTerminal(this.m_Interface);
            this.m_Terminal.setLocalPort(this.m_Port);
            this.m_Terminal.activate();
            this.m_Transport = new ModbusUDPTransport(this.m_Terminal);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.m_Listening = false;
            return;
        }
        this.m_Listening = true;
        this.m_Continue = true;
        try {
            try {
                while (this.m_Continue) {
                    ModbusRequest request = this.m_Transport.readRequest();
                    ModbusResponse response = null;
                    response = ModbusCoupler.getReference().getProcessImage() == null ? request.createExceptionResponse(1) : request.createResponse();
                    System.err.println("Request:" + request.getHexMessage());
                    System.err.println("Response:" + response.getHexMessage());
                    this.m_Transport.writeMessage(response);
                }
            }
            catch (ModbusIOException ex) {
                if (!ex.isEOF()) {
                    ex.printStackTrace();
                }
                try {
                    this.m_Terminal.deactivate();
                    this.m_Transport.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                this.m_Terminal.deactivate();
                this.m_Transport.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void stop() {
        this.m_Terminal.deactivate();
        this.m_Listening = false;
        this.m_Continue = false;
    }

    @Override
    public void setListening(boolean listen) {
        this.m_Listening = listen;
    }

    @Override
    public boolean isListening() {
        return this.m_Listening;
    }

    @Override
    public Thread listen() {
        this.m_Listening = true;
        Thread result = new Thread(this);
        result.start();
        return result;
    }

    public ModbusUDPListener(InetAddress ifc) {
        this.m_Interface = ifc;
        this.m_Listening = true;
    }

    public ModbusUDPListener() {
        try {
            this.m_Interface = InetAddress.getByAddress(new byte[4]);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }
}

