/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.net;

import com.ghgande.j2mod.modbus.io.ModbusASCIITransport;
import com.ghgande.j2mod.modbus.io.ModbusBINTransport;
import com.ghgande.j2mod.modbus.io.ModbusRTUTransport;
import com.ghgande.j2mod.modbus.io.ModbusSerialTransport;
import com.ghgande.j2mod.modbus.io.ModbusTransport;
import com.ghgande.j2mod.modbus.util.SerialParameters;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.RXTXPort;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.TooManyListenersException;

public class SerialConnection
implements SerialPortEventListener {
    private SerialParameters m_Parameters;
    private ModbusSerialTransport m_Transport;
    private SerialPort m_SerialPort;
    private boolean m_Open;
    private InputStream m_SerialIn;

    public SerialConnection(SerialParameters parameters) {
        this.m_Parameters = parameters;
        this.m_Open = false;
    }

    public void close() {
        if (!this.m_Open) {
            return;
        }
        if (this.m_SerialPort != null) {
            try {
                this.m_Transport.close();
                this.m_SerialIn.close();
            }
            catch (IOException e) {
                System.err.println(e);
            }
            this.m_SerialPort.close();
        }
        this.m_Open = false;
    }

    public ModbusTransport getModbusTransport() {
        return this.m_Transport;
    }

    public boolean isOpen() {
        return this.m_Open;
    }

    public void open() throws Exception {
        try {
            CommPortIdentifier m_PortIdentifier = CommPortIdentifier.getPortIdentifier(this.m_Parameters.getPortName());
            this.m_SerialPort = (SerialPort)m_PortIdentifier.open("Modbus Serial Master", 3000);
        }
        catch (PortInUseException e) {
            System.out.println(e.getMessage());
            throw new Exception(e.getMessage());
        }
        catch (NoSuchPortException e) {
            try {
                this.m_SerialPort = new RXTXPort(this.m_Parameters.getPortName());
            }
            catch (PortInUseException x) {
                x.printStackTrace();
                throw new Exception(x.getMessage());
            }
        }
        try {
            this.setConnectionParameters();
        }
        catch (Exception e) {
            this.m_SerialPort.close();
            System.out.println(e.getMessage());
            throw e;
        }
        if ("ascii".equals(this.m_Parameters.getEncoding())) {
            this.m_Transport = new ModbusASCIITransport();
        } else if ("rtu".equals(this.m_Parameters.getEncoding())) {
            this.m_Transport = new ModbusRTUTransport();
        } else if ("bin".equals(this.m_Parameters.getEncoding())) {
            this.m_Transport = new ModbusBINTransport();
        }
        this.m_Transport.setEcho(this.m_Parameters.isEcho());
        try {
            this.m_SerialIn = this.m_SerialPort.getInputStream();
            this.m_Transport.setCommPort(this.m_SerialPort);
        }
        catch (IOException e) {
            this.m_SerialPort.close();
            System.out.println(e.getMessage());
            throw new Exception("Error opening i/o streams");
        }
        try {
            this.m_SerialPort.addEventListener(this);
        }
        catch (TooManyListenersException e) {
            this.m_SerialPort.close();
            System.out.println(e.getMessage());
            throw new Exception("too many listeners added");
        }
        this.m_SerialPort.notifyOnBreakInterrupt(true);
        try {
            this.m_SerialPort.enableReceiveTimeout(200);
        }
        catch (UnsupportedCommOperationException e) {
            System.out.println(e.getMessage());
        }
        this.m_Open = true;
    }

    @Override
    public void serialEvent(SerialPortEvent e) {
        switch (e.getEventType()) {
            case 1: {
                break;
            }
            case 10: {
                System.out.println("Serial port break detected");
                break;
            }
            default: {
                System.out.println("Serial port event: " + e.getEventType());
            }
        }
    }

    public void setConnectionParameters() throws Exception {
        int oldBaudRate = this.m_SerialPort.getBaudRate();
        int oldDatabits = this.m_SerialPort.getDataBits();
        int oldStopbits = this.m_SerialPort.getStopBits();
        int oldParity = this.m_SerialPort.getParity();
        int oldFlowControl = this.m_SerialPort.getFlowControlMode();
        try {
            this.m_SerialPort.setSerialPortParams(this.m_Parameters.getBaudRate(), this.m_Parameters.getDatabits(), this.m_Parameters.getStopbits(), this.m_Parameters.getParity());
        }
        catch (UnsupportedCommOperationException e) {
            this.m_Parameters.setBaudRate(oldBaudRate);
            this.m_Parameters.setDatabits(oldDatabits);
            this.m_Parameters.setStopbits(oldStopbits);
            this.m_Parameters.setParity(oldParity);
            this.m_Parameters.setFlowControlIn(oldFlowControl);
            System.out.println(e.getMessage());
            throw new Exception("Unsupported parameter");
        }
        try {
            this.m_SerialPort.setFlowControlMode(this.m_Parameters.getFlowControlIn() | this.m_Parameters.getFlowControlOut());
        }
        catch (UnsupportedCommOperationException e) {
            System.out.println(e.getMessage());
            throw new Exception("Unsupported flow control");
        }
    }
}

