/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.net;

import com.ghgande.j2mod.modbus.ModbusCoupler;
import com.ghgande.j2mod.modbus.ModbusIOException;
import com.ghgande.j2mod.modbus.io.ModbusTransport;
import com.ghgande.j2mod.modbus.msg.ModbusRequest;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.net.TCPSlaveConnection;
import com.ghgande.j2mod.modbus.procimg.ProcessImage;

public class TCPConnectionHandler
implements Runnable {
    private TCPSlaveConnection m_Connection;
    private ModbusTransport m_Transport;

    public TCPConnectionHandler(TCPSlaveConnection con) {
        this.setConnection(con);
    }

    public void setConnection(TCPSlaveConnection con) {
        this.m_Connection = con;
        this.m_Transport = this.m_Connection.getModbusTransport();
    }

    @Override
    public void run() {
        try {
            try {
                while (true) {
                    ModbusRequest request = this.m_Transport.readRequest();
                    ModbusResponse response = null;
                    ProcessImage image = ModbusCoupler.getReference().getProcessImage();
                    if (image == null || image.getUnitID() != 0 && request.getUnitID() != image.getUnitID()) continue;
                    response = request.createResponse();
                    System.out.println("Request:" + request.getHexMessage());
                    System.out.println("Response:" + response.getHexMessage());
                    this.m_Transport.writeMessage(response);
                }
            }
            catch (ModbusIOException ex) {
                if (!ex.isEOF()) {
                    ex.printStackTrace();
                }
                try {
                    this.m_Connection.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (Throwable throwable) {
            try {
                this.m_Connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }
}

