/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.net;

import com.ghgande.j2mod.modbus.io.ModbusTCPTransport;
import com.ghgande.j2mod.modbus.io.ModbusTransport;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

public class TCPMasterConnection {
    private Socket m_Socket;
    private int m_Timeout = 3000;
    private boolean m_Connected;
    private InetAddress m_Address;
    private int m_Port = 502;
    private ModbusTCPTransport m_ModbusTransport;
    private boolean m_useUrgentData = false;

    private void prepareTransport() throws IOException {
        if (this.m_ModbusTransport == null) {
            this.m_ModbusTransport = new ModbusTCPTransport(this.m_Socket);
        } else {
            this.m_ModbusTransport.setSocket(this.m_Socket);
        }
    }

    public synchronized void connect() throws Exception {
        if (!this.isConnected()) {
            System.out.println("connect()");
            this.m_Socket = new Socket(this.m_Address, this.m_Port);
            this.m_Socket.setReuseAddress(true);
            this.m_Socket.setSoLinger(true, 1);
            this.m_Socket.setKeepAlive(true);
            this.setTimeout(this.m_Timeout);
            this.prepareTransport();
            this.m_Connected = true;
        }
    }

    public synchronized boolean isConnected() {
        if (this.m_Connected && this.m_Socket != null) {
            if (!this.m_Socket.isConnected() || this.m_Socket.isClosed() || this.m_Socket.isInputShutdown() || this.m_Socket.isOutputShutdown()) {
                try {
                    this.m_Socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.m_Connected = false;
            } else if (this.m_useUrgentData) {
                try {
                    this.m_Socket.sendUrgentData(0);
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (IOException e) {
                    this.m_Connected = false;
                    try {
                        this.m_Socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        return this.m_Connected;
    }

    public void close() {
        if (this.m_Connected) {
            try {
                this.m_ModbusTransport.close();
            }
            catch (IOException ex) {
                System.out.println("close()");
            }
            this.m_Connected = false;
        }
    }

    public ModbusTransport getModbusTransport() {
        return this.m_ModbusTransport;
    }

    public void setModbusTransport(ModbusTCPTransport trans) {
        this.m_ModbusTransport = trans;
    }

    public int getTimeout() {
        return this.m_Timeout;
    }

    public void setTimeout(int timeout) {
        try {
            this.m_Socket.setSoTimeout(this.m_Timeout);
            this.m_Timeout = timeout;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getPort() {
        return this.m_Port;
    }

    public void setPort(int port) {
        this.m_Port = port;
    }

    public InetAddress getAddress() {
        return this.m_Address;
    }

    public void setAddress(InetAddress adr) {
        this.m_Address = adr;
    }

    public boolean getUseUrgentData() {
        return this.m_useUrgentData;
    }

    public void setUseUrgentData(boolean useUrgentData) {
        this.m_useUrgentData = useUrgentData;
    }

    public TCPMasterConnection(InetAddress adr) {
        this.m_Address = adr;
    }
}

