/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.net;

import com.ghgande.j2mod.modbus.io.ModbusTCPTransport;
import com.ghgande.j2mod.modbus.io.ModbusTransport;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

public class TCPSlaveConnection {
    private Socket m_Socket;
    private int m_Unit = 0;
    private int m_Timeout = 3000;
    private boolean m_Connected;
    private ModbusTCPTransport m_ModbusTransport;

    public TCPSlaveConnection(Socket socket) {
        try {
            this.setSocket(socket);
        }
        catch (IOException ex) {
            System.out.println("TCPSlaveConnection::Socket invalid.");
            throw new IllegalStateException("Socket invalid.");
        }
    }

    public TCPSlaveConnection(Socket socket, int unit) {
        this.m_Unit = unit;
        try {
            this.setSocket(socket);
        }
        catch (IOException ex) {
            System.out.println("TCPSlaveConnection::Socket invalid.");
            throw new IllegalStateException("Socket invalid.");
        }
    }

    public void close() {
        if (this.m_Connected) {
            try {
                this.m_ModbusTransport.close();
                this.m_Socket.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.m_Connected = false;
        }
    }

    public ModbusTransport getModbusTransport() {
        return this.m_ModbusTransport;
    }

    private void setSocket(Socket socket) throws IOException {
        this.m_Socket = socket;
        if (this.m_ModbusTransport == null) {
            this.m_ModbusTransport = new ModbusTCPTransport(this.m_Socket);
        } else {
            this.m_ModbusTransport.setSocket(this.m_Socket);
        }
        this.m_Connected = true;
    }

    public int getTimeout() {
        return this.m_Timeout;
    }

    public void setTimeout(int timeout) {
        this.m_Timeout = timeout;
        try {
            this.m_Socket.setSoTimeout(this.m_Timeout);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getPort() {
        return this.m_Socket.getLocalPort();
    }

    public InetAddress getAddress() {
        return this.m_Socket.getLocalAddress();
    }

    public int getUnitNumber() {
        return this.m_Unit;
    }

    public boolean isConnected() {
        return this.m_Connected;
    }
}

