/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.net;

import com.ghgande.j2mod.modbus.io.ModbusUDPTransport;
import com.ghgande.j2mod.modbus.net.UDPTerminal;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

class UDPMasterTerminal
implements UDPTerminal {
    private DatagramSocket m_Socket;
    private int m_Timeout = 3000;
    private boolean m_Active;
    protected InetAddress m_LocalAddress;
    protected InetAddress m_RemoteAddress;
    private int m_RemotePort = 502;
    private int m_LocalPort = 502;
    protected ModbusUDPTransport m_ModbusTransport;

    @Override
    public InetAddress getLocalAddress() {
        return this.m_LocalAddress;
    }

    public void setLocalAddress(InetAddress addr) {
        this.m_LocalAddress = addr;
    }

    @Override
    public int getLocalPort() {
        return this.m_LocalPort;
    }

    protected void setLocalPort(int port) {
        this.m_LocalPort = port;
    }

    public int getRemotePort() {
        return this.m_RemotePort;
    }

    public void setRemotePort(int port) {
        this.m_RemotePort = port;
    }

    public InetAddress getRemoteAddress() {
        return this.m_RemoteAddress;
    }

    public void setRemoteAddress(InetAddress adr) {
        this.m_RemoteAddress = adr;
    }

    @Override
    public boolean isActive() {
        return this.m_Active;
    }

    @Override
    public synchronized void activate() throws Exception {
        if (!this.isActive()) {
            System.out.println("UDPMasterTerminal::activate()::laddr=:" + this.m_LocalAddress + ":lport=" + this.m_LocalPort);
            if (this.m_Socket == null) {
                if (this.m_LocalAddress != null && this.m_LocalPort != -1) {
                    this.m_Socket = new DatagramSocket(this.m_LocalPort, this.m_LocalAddress);
                } else {
                    this.m_Socket = new DatagramSocket();
                    this.m_LocalPort = this.m_Socket.getLocalPort();
                    this.m_LocalAddress = this.m_Socket.getLocalAddress();
                }
            }
            System.out.println("UDPMasterTerminal::haveSocket():" + this.m_Socket.toString());
            System.out.println("UDPMasterTerminal::laddr=:" + this.m_LocalAddress.toString() + ":lport=" + this.m_LocalPort);
            System.out.println("UDPMasterTerminal::raddr=:" + this.m_RemoteAddress.toString() + ":rport=" + this.m_RemotePort);
            this.m_Socket.setReceiveBufferSize(1024);
            this.m_Socket.setSendBufferSize(1024);
            this.m_ModbusTransport = new ModbusUDPTransport(this);
            this.m_Active = true;
        }
        System.out.println("UDPMasterTerminal::activated");
    }

    @Override
    public void deactivate() {
        try {
            System.out.println("UDPMasterTerminal::deactivate()");
            this.m_Socket.close();
            this.m_ModbusTransport = null;
            this.m_Active = false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public ModbusUDPTransport getModbusTransport() {
        return this.m_ModbusTransport;
    }

    public int getTimeout() {
        return this.m_Timeout;
    }

    public void setTimeout(int timeout) {
        this.m_Timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(byte[] msg) throws Exception {
        DatagramPacket req = new DatagramPacket(msg, msg.length, this.m_RemoteAddress, this.m_RemotePort);
        DatagramSocket datagramSocket = this.m_Socket;
        synchronized (datagramSocket) {
            this.m_Socket.send(req);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] receiveMessage() throws Exception {
        byte[] buffer = new byte[262];
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
        DatagramSocket datagramSocket = this.m_Socket;
        synchronized (datagramSocket) {
            this.m_Socket.setSoTimeout(this.m_Timeout);
            this.m_Socket.receive(packet);
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveMessage(byte[] buffer) throws Exception {
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
        DatagramSocket datagramSocket = this.m_Socket;
        synchronized (datagramSocket) {
            this.m_Socket.setSoTimeout(this.m_Timeout);
            this.m_Socket.receive(packet);
        }
    }

    protected UDPMasterTerminal(InetAddress addr) {
        this.m_RemoteAddress = addr;
    }

    public UDPMasterTerminal() {
    }
}

