/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.net;

import com.ghgande.j2mod.modbus.io.ModbusUDPTransport;
import com.ghgande.j2mod.modbus.net.UDPTerminal;
import com.ghgande.j2mod.modbus.util.LinkedQueue;
import com.ghgande.j2mod.modbus.util.ModbusUtil;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Hashtable;

class UDPSlaveTerminal
implements UDPTerminal {
    private DatagramSocket m_Socket;
    private int m_Timeout = 3000;
    private boolean m_Active;
    protected InetAddress m_LocalAddress;
    private int m_LocalPort = 502;
    protected ModbusUDPTransport m_ModbusTransport;
    private LinkedQueue m_SendQueue;
    private LinkedQueue m_ReceiveQueue;
    private PacketSender m_PacketSender;
    private PacketReceiver m_PacketReceiver;
    private Thread m_Receiver;
    private Thread m_Sender;
    protected Hashtable<Integer, DatagramPacket> m_Requests;

    protected UDPSlaveTerminal() {
        this.m_SendQueue = new LinkedQueue();
        this.m_ReceiveQueue = new LinkedQueue();
        this.m_Requests = new Hashtable(342);
    }

    protected UDPSlaveTerminal(InetAddress localaddress) {
        this.m_LocalAddress = localaddress;
        this.m_SendQueue = new LinkedQueue();
        this.m_ReceiveQueue = new LinkedQueue();
        this.m_Requests = new Hashtable(342);
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.m_LocalAddress;
    }

    @Override
    public int getLocalPort() {
        return this.m_LocalPort;
    }

    protected void setLocalPort(int port) {
        this.m_LocalPort = port;
    }

    @Override
    public boolean isActive() {
        return this.m_Active;
    }

    @Override
    public synchronized void activate() throws Exception {
        if (!this.isActive()) {
            System.out.println("UDPSlaveTerminal.activate()");
            if (this.m_Socket == null) {
                if (this.m_LocalAddress != null && this.m_LocalPort != -1) {
                    this.m_Socket = new DatagramSocket(this.m_LocalPort, this.m_LocalAddress);
                } else {
                    this.m_Socket = new DatagramSocket();
                    this.m_LocalPort = this.m_Socket.getLocalPort();
                    this.m_LocalAddress = this.m_Socket.getLocalAddress();
                }
            }
            System.out.println("UDPSlaveTerminal::haveSocket():" + this.m_Socket.toString());
            System.out.println("UDPSlaveTerminal::addr=:" + this.m_LocalAddress.toString() + ":port=" + this.m_LocalPort);
            this.m_Socket.setReceiveBufferSize(1024);
            this.m_Socket.setSendBufferSize(1024);
            this.m_PacketReceiver = new PacketReceiver();
            this.m_Receiver = new Thread(this.m_PacketReceiver);
            this.m_Receiver.start();
            System.out.println("UDPSlaveTerminal::receiver started()");
            this.m_PacketSender = new PacketSender();
            this.m_Sender = new Thread(this.m_PacketSender);
            this.m_Sender.start();
            System.out.println("UDPSlaveTerminal::sender started()");
            this.m_ModbusTransport = new ModbusUDPTransport(this);
            System.out.println("UDPSlaveTerminal::transport created");
            this.m_Active = true;
        }
        System.out.println("UDPSlaveTerminal::activated");
    }

    @Override
    public void deactivate() {
        try {
            if (this.m_Active) {
                this.m_PacketReceiver.stop();
                this.m_Receiver.join();
                this.m_PacketSender.stop();
                this.m_Sender.join();
                this.m_Socket.close();
                this.m_ModbusTransport = null;
                this.m_Active = false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public ModbusUDPTransport getModbusTransport() {
        return this.m_ModbusTransport;
    }

    protected boolean hasResponse() {
        return !this.m_ReceiveQueue.isEmpty();
    }

    public void setTimeout(int timeout) {
        this.m_Timeout = timeout;
        try {
            this.m_Socket.setSoTimeout(this.m_Timeout);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public DatagramSocket getSocket() {
        return this.m_Socket;
    }

    protected void setSocket(DatagramSocket sock) {
        this.m_Socket = sock;
    }

    @Override
    public void sendMessage(byte[] msg) throws Exception {
        this.m_SendQueue.put(msg);
    }

    @Override
    public byte[] receiveMessage() throws Exception {
        return (byte[])this.m_ReceiveQueue.take();
    }

    class PacketReceiver
    implements Runnable {
        private boolean m_Continue = true;

        @Override
        public void run() {
            do {
                try {
                    byte[] buffer = new byte[256];
                    DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                    UDPSlaveTerminal.this.m_Socket.receive(packet);
                    Integer tid = new Integer(ModbusUtil.registersToInt(buffer));
                    UDPSlaveTerminal.this.m_Requests.put(tid, packet);
                    UDPSlaveTerminal.this.m_ReceiveQueue.put(buffer);
                    System.out.println("Received package to queue.");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } while (this.m_Continue);
        }

        public void stop() {
            this.m_Continue = false;
        }
    }

    class PacketSender
    implements Runnable {
        private boolean m_Continue = true;

        @Override
        public void run() {
            do {
                try {
                    byte[] message = (byte[])UDPSlaveTerminal.this.m_SendQueue.take();
                    DatagramPacket req = UDPSlaveTerminal.this.m_Requests.remove(new Integer(ModbusUtil.registersToInt(message)));
                    DatagramPacket res = new DatagramPacket(message, message.length, req.getAddress(), req.getPort());
                    UDPSlaveTerminal.this.m_Socket.send(res);
                    System.out.println("Sent package from queue.");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } while (this.m_Continue || !UDPSlaveTerminal.this.m_SendQueue.isEmpty());
        }

        public void stop() {
            this.m_Continue = false;
        }
    }
}

