/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.procimg;

import com.ghgande.j2mod.modbus.procimg.Register;
import com.ghgande.j2mod.modbus.procimg.SimpleRegister;
import java.util.Vector;

public class FIFO {
    private int m_Address;
    private int m_Register_Count;
    private Vector<Register> m_Registers;

    public synchronized int getRegisterCount() {
        return this.m_Register_Count;
    }

    public synchronized Register[] getRegisters() {
        Register[] result = new Register[this.m_Register_Count + 1];
        result[0] = new SimpleRegister(this.m_Register_Count);
        int i = 0;
        while (i < this.m_Register_Count) {
            result[i + 1] = this.m_Registers.get(i);
            ++i;
        }
        return result;
    }

    public synchronized void pushRegister(Register register) {
        if (this.m_Register_Count == 31) {
            this.m_Registers.remove(0);
        } else {
            ++this.m_Register_Count;
        }
        this.m_Registers.add(new SimpleRegister(register.getValue()));
    }

    public synchronized void resetRegisters() {
        this.m_Registers.removeAllElements();
        this.m_Register_Count = 0;
    }

    public int getAddress() {
        return this.m_Address;
    }

    public FIFO(int address) {
        this.m_Address = address;
        this.m_Register_Count = 0;
        this.m_Registers = new Vector();
    }
}

