/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.procimg;

import com.ghgande.j2mod.modbus.procimg.DigitalIn;
import com.ghgande.j2mod.modbus.procimg.DigitalOut;
import com.ghgande.j2mod.modbus.procimg.FIFO;
import com.ghgande.j2mod.modbus.procimg.File;
import com.ghgande.j2mod.modbus.procimg.IllegalAddressException;
import com.ghgande.j2mod.modbus.procimg.InputRegister;
import com.ghgande.j2mod.modbus.procimg.ProcessImageImplementation;
import com.ghgande.j2mod.modbus.procimg.Register;
import java.util.Vector;

public class SimpleProcessImage
implements ProcessImageImplementation {
    protected Vector<DigitalIn> m_DigitalInputs = new Vector();
    protected Vector<DigitalOut> m_DigitalOutputs = new Vector();
    protected Vector<InputRegister> m_InputRegisters = new Vector();
    protected Vector<Register> m_Registers = new Vector();
    protected Vector<File> m_Files = new Vector();
    protected Vector<FIFO> m_FIFOs;
    protected boolean m_Locked = false;
    protected int m_Unit = 0;

    public SimpleProcessImage() {
    }

    public SimpleProcessImage(int unit) {
        this.m_Unit = unit;
    }

    public synchronized boolean isLocked() {
        return this.m_Locked;
    }

    public synchronized boolean setLocked(boolean locked) {
        if (this.m_Locked && locked) {
            return false;
        }
        this.m_Locked = locked;
        return true;
    }

    @Override
    public int getUnitID() {
        return this.m_Unit;
    }

    @Override
    public void addDigitalIn(DigitalIn di) {
        if (!this.isLocked()) {
            this.m_DigitalInputs.addElement(di);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDigitalIn(int ref, DigitalIn d1) {
        if (ref < 0 || ref >= 65536) {
            throw new IllegalArgumentException();
        }
        if (!this.isLocked()) {
            Vector<DigitalIn> vector = this.m_DigitalInputs;
            synchronized (vector) {
                if (ref < this.m_DigitalInputs.size()) {
                    this.m_DigitalInputs.setElementAt(d1, ref);
                    return;
                }
                this.m_DigitalInputs.setSize(ref + 1);
                this.m_DigitalInputs.setElementAt(d1, ref);
            }
        }
    }

    @Override
    public void removeDigitalIn(DigitalIn di) {
        if (!this.isLocked()) {
            this.m_DigitalInputs.removeElement(di);
        }
    }

    @Override
    public void setDigitalIn(int ref, DigitalIn di) throws IllegalAddressException {
        if (!this.isLocked()) {
            try {
                if (this.m_DigitalInputs.get(ref) == null) {
                    throw new IllegalAddressException();
                }
                this.m_DigitalInputs.setElementAt(di, ref);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new IllegalAddressException();
            }
        }
    }

    @Override
    public DigitalIn getDigitalIn(int ref) throws IllegalAddressException {
        try {
            DigitalIn result = this.m_DigitalInputs.elementAt(ref);
            if (result == null) {
                throw new IllegalAddressException();
            }
            return result;
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalAddressException();
        }
    }

    @Override
    public int getDigitalInCount() {
        return this.m_DigitalInputs.size();
    }

    @Override
    public DigitalIn[] getDigitalInRange(int ref, int count) {
        if (ref < 0 || ref + count > this.m_DigitalInputs.size()) {
            throw new IllegalAddressException();
        }
        DigitalIn[] dins = new DigitalIn[count];
        int i = 0;
        while (i < dins.length) {
            dins[i] = this.getDigitalIn(ref + i);
            ++i;
        }
        return dins;
    }

    @Override
    public void addDigitalOut(DigitalOut _do) {
        if (!this.isLocked()) {
            this.m_DigitalOutputs.addElement(_do);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDigitalOut(int ref, DigitalOut dout) {
        if (ref < 0 || ref >= 65536) {
            throw new IllegalArgumentException();
        }
        if (!this.isLocked()) {
            Vector<DigitalOut> vector = this.m_DigitalOutputs;
            synchronized (vector) {
                if (ref < this.m_DigitalOutputs.size()) {
                    this.m_DigitalOutputs.setElementAt(dout, ref);
                    return;
                }
                this.m_DigitalOutputs.setSize(ref + 1);
                this.m_DigitalOutputs.setElementAt(dout, ref);
            }
        }
    }

    @Override
    public void removeDigitalOut(DigitalOut _do) {
        if (!this.isLocked()) {
            this.m_DigitalOutputs.removeElement(_do);
        }
    }

    @Override
    public void setDigitalOut(int ref, DigitalOut _do) throws IllegalAddressException {
        if (!this.isLocked()) {
            try {
                if (this.m_DigitalOutputs.get(ref) == null) {
                    throw new IllegalAddressException();
                }
                this.m_DigitalOutputs.setElementAt(_do, ref);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new IllegalAddressException();
            }
        }
    }

    @Override
    public DigitalOut getDigitalOut(int ref) throws IllegalAddressException {
        try {
            DigitalOut result = this.m_DigitalOutputs.elementAt(ref);
            if (result == null) {
                throw new IllegalAddressException();
            }
            return result;
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalAddressException();
        }
    }

    @Override
    public int getDigitalOutCount() {
        return this.m_DigitalOutputs.size();
    }

    @Override
    public DigitalOut[] getDigitalOutRange(int ref, int count) {
        if (ref < 0 || ref + count > this.m_DigitalOutputs.size()) {
            throw new IllegalAddressException();
        }
        DigitalOut[] douts = new DigitalOut[count];
        int i = 0;
        while (i < douts.length) {
            douts[i] = this.getDigitalOut(ref + i);
            ++i;
        }
        return douts;
    }

    @Override
    public void addInputRegister(InputRegister reg) {
        if (!this.isLocked()) {
            this.m_InputRegisters.addElement(reg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInputRegister(int ref, InputRegister inReg) {
        if (ref < 0 || ref >= 65536) {
            throw new IllegalArgumentException();
        }
        if (!this.isLocked()) {
            Vector<InputRegister> vector = this.m_InputRegisters;
            synchronized (vector) {
                if (ref < this.m_InputRegisters.size()) {
                    this.m_InputRegisters.setElementAt(inReg, ref);
                    return;
                }
                this.m_InputRegisters.setSize(ref + 1);
                this.m_InputRegisters.setElementAt(inReg, ref);
            }
        }
    }

    @Override
    public void removeInputRegister(InputRegister reg) {
        if (!this.isLocked()) {
            this.m_InputRegisters.removeElement(reg);
        }
    }

    @Override
    public void setInputRegister(int ref, InputRegister reg) throws IllegalAddressException {
        if (!this.isLocked()) {
            try {
                if (this.m_InputRegisters.get(ref) == null) {
                    throw new IllegalAddressException();
                }
                this.m_InputRegisters.setElementAt(reg, ref);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new IllegalAddressException();
            }
        }
    }

    @Override
    public InputRegister getInputRegister(int ref) throws IllegalAddressException {
        try {
            InputRegister result = this.m_InputRegisters.elementAt(ref);
            if (result == null) {
                throw new IllegalAddressException();
            }
            return result;
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalAddressException();
        }
    }

    @Override
    public int getInputRegisterCount() {
        return this.m_InputRegisters.size();
    }

    @Override
    public InputRegister[] getInputRegisterRange(int ref, int count) {
        if (ref < 0 || ref + count > this.m_InputRegisters.size()) {
            throw new IllegalAddressException();
        }
        InputRegister[] iregs = new InputRegister[count];
        int i = 0;
        while (i < iregs.length) {
            iregs[i] = this.getInputRegister(ref + i);
            ++i;
        }
        return iregs;
    }

    @Override
    public void addRegister(Register reg) {
        if (!this.isLocked()) {
            this.m_Registers.addElement(reg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRegister(int ref, Register reg) {
        if (ref < 0 || ref >= 65536) {
            throw new IllegalArgumentException();
        }
        if (!this.isLocked()) {
            Vector<Register> vector = this.m_Registers;
            synchronized (vector) {
                if (ref < this.m_Registers.size()) {
                    this.m_Registers.setElementAt(reg, ref);
                    return;
                }
                this.m_Registers.setSize(ref + 1);
                this.m_Registers.setElementAt(reg, ref);
            }
        }
    }

    @Override
    public void removeRegister(Register reg) {
        if (!this.isLocked()) {
            this.m_Registers.removeElement(reg);
        }
    }

    @Override
    public void setRegister(int ref, Register reg) throws IllegalAddressException {
        if (!this.isLocked()) {
            try {
                if (this.m_Registers.get(ref) == null) {
                    throw new IllegalAddressException();
                }
                this.m_Registers.setElementAt(reg, ref);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new IllegalAddressException();
            }
        }
    }

    @Override
    public Register getRegister(int ref) throws IllegalAddressException {
        try {
            Register result = this.m_Registers.elementAt(ref);
            if (result == null) {
                throw new IllegalAddressException();
            }
            return result;
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalAddressException();
        }
    }

    @Override
    public int getRegisterCount() {
        return this.m_Registers.size();
    }

    @Override
    public Register[] getRegisterRange(int ref, int count) {
        if (ref < 0 || ref + count > this.m_Registers.size()) {
            throw new IllegalAddressException();
        }
        Register[] iregs = new Register[count];
        int i = 0;
        while (i < iregs.length) {
            iregs[i] = this.getRegister(ref + i);
            ++i;
        }
        return iregs;
    }

    @Override
    public void addFile(File newFile) {
        if (!this.isLocked()) {
            this.m_Files.add(newFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFile(int ref, File newFile) {
        if (ref < 0 || ref >= 65536) {
            throw new IllegalArgumentException();
        }
        if (!this.isLocked()) {
            Vector<File> vector = this.m_Files;
            synchronized (vector) {
                if (ref < this.m_Files.size()) {
                    this.m_Files.setElementAt(newFile, ref);
                    return;
                }
                this.m_Files.setSize(ref + 1);
                this.m_Files.setElementAt(newFile, ref);
            }
        }
    }

    @Override
    public void removeFile(File oldFile) {
        if (!this.isLocked()) {
            this.m_Files.removeElement(oldFile);
        }
    }

    @Override
    public void setFile(int fileNumber, File file) {
        if (!this.isLocked()) {
            try {
                if (this.m_Files.get(fileNumber) == null) {
                    throw new IllegalAddressException();
                }
                this.m_Files.setElementAt(file, fileNumber);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new IllegalAddressException();
            }
        }
    }

    @Override
    public File getFile(int fileNumber) {
        try {
            File result = this.m_Files.elementAt(fileNumber);
            if (result == null) {
                throw new IllegalAddressException();
            }
            return result;
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalAddressException();
        }
    }

    @Override
    public int getFileCount() {
        return this.m_Files.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getFileByNumber(int ref) {
        if (ref < 0 || ref >= 10000 || this.m_Files == null) {
            throw new IllegalAddressException();
        }
        Vector<File> vector = this.m_Files;
        synchronized (vector) {
            for (File file : this.m_Files) {
                if (file.getFileNumber() != ref) continue;
                return file;
            }
        }
        throw new IllegalAddressException();
    }

    @Override
    public void addFIFO(FIFO fifo) {
        if (!this.isLocked()) {
            this.m_FIFOs.add(fifo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFIFO(int ref, FIFO newFIFO) {
        if (ref < 0 || ref >= 65536) {
            throw new IllegalArgumentException();
        }
        if (!this.isLocked()) {
            Vector<FIFO> vector = this.m_FIFOs;
            synchronized (vector) {
                if (ref < this.m_FIFOs.size()) {
                    this.m_FIFOs.setElementAt(newFIFO, ref);
                    return;
                }
                this.m_FIFOs.setSize(ref + 1);
                this.m_FIFOs.setElementAt(newFIFO, ref);
            }
        }
    }

    @Override
    public void removeFIFO(FIFO oldFIFO) {
        if (!this.isLocked()) {
            this.m_FIFOs.removeElement(oldFIFO);
        }
    }

    @Override
    public void setFIFO(int fifoNumber, FIFO fifo) {
        if (!this.isLocked()) {
            try {
                if (this.m_FIFOs.get(fifoNumber) == null) {
                    throw new IllegalAddressException();
                }
                this.m_FIFOs.setElementAt(fifo, fifoNumber);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new IllegalAddressException();
            }
        }
    }

    @Override
    public FIFO getFIFO(int fifoNumber) {
        try {
            FIFO result = this.m_FIFOs.elementAt(fifoNumber);
            if (result == null) {
                throw new IllegalAddressException();
            }
            return result;
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalAddressException();
        }
    }

    @Override
    public int getFIFOCount() {
        if (this.m_FIFOs == null) {
            return 0;
        }
        return this.m_FIFOs.size();
    }

    @Override
    public FIFO getFIFOByAddress(int ref) {
        for (FIFO fifo : this.m_FIFOs) {
            if (fifo.getAddress() != ref) continue;
            return fifo;
        }
        return null;
    }
}

