/*
 * Decompiled with CFR 0.152.
 */
package fr.iiprocess.marina.config;

import fr.iiprocess.marina.Globals;
import fr.iiprocess.marina.config.AffichageControl;
import fr.iiprocess.marina.model.Values;
import fr.iiprocess.marina.serial.DaemonReader;
import fr.iiprocess.marina.serial.IModbusListener;
import fr.iiprocess.marina.serial.ModbusHelper;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.VBox;

public class AfficherBorneController
implements IModbusListener {
    private static final String CONNEXION_ON = "connexion_on";
    private static final String CONNEXION_OFF = "connexion_off";
    private static final String CONNEXION_ERREUR = "connexion_erreur";
    private static final String ES_ON = "es_on";
    private static final String ES_OFF = "es_off";
    @FXML
    private Button mConfig;
    @FXML
    private Button mForcage;
    @FXML
    private Button mWifi;
    @FXML
    private Label mSlaveId;
    @FXML
    private Label mCarteId;
    @FXML
    private Label mTemperature;
    @FXML
    private Label mVoyantVert;
    @FXML
    private Label mVoyantRouge;
    @FXML
    private Label mVersion;
    @FXML
    private Label mModeCarte;
    @FXML
    private Label mModeComptage;
    @FXML
    private Label mNumZone;
    @FXML
    private VBox mContent;
    @FXML
    private ToggleButton mConnect;
    @FXML
    private Label mVoyantHautTexte;
    @FXML
    private Label mVoyantHautCadre;
    @FXML
    private Label mVoyantBasTexte;
    @FXML
    private Label mVoyantBasCadre;
    @FXML
    private AffichageControl mAffichage1;
    @FXML
    private AffichageControl mAffichage2;
    @FXML
    private AffichageControl mAffichage3;
    @FXML
    private AffichageControl mAffichage4;
    @FXML
    private AffichageControl mAffichage5;
    @FXML
    private AffichageControl mAffichage6;
    @FXML
    private AffichageControl mAffichage7;
    @FXML
    private AffichageControl mAffichage8;
    @FXML
    private Label mE1;
    @FXML
    private Label mE2;
    @FXML
    private Label mE3;
    @FXML
    private Label mE4;
    @FXML
    private Label mS1;
    @FXML
    private Label mS2;
    @FXML
    private Label mS3;
    @FXML
    private Label mS4;
    private AffichageControl[] mCompteurs = new AffichageControl[8];
    private InOut[] mEntrees = new InOut[4];
    private InOut[] mSorties = new InOut[4];
    private final NumberFormat NF = NumberFormat.getIntegerInstance();
    @FXML
    private Label mDate;
    @FXML
    private Label mVersionApp;

    public AfficherBorneController() {
        this.NF.setGroupingUsed(false);
        this.NF.setMinimumIntegerDigits(6);
    }

    public void wifi() {
        DaemonReader.getInstance().stop();
        ModbusHelper.getInstance().disconnect();
        Globals.getInstance().AfficherBornePane.setDisable(true);
        Globals.getInstance().RacinePane.setCenter((Node)Globals.getInstance().ConfigurerWifiPane);
        Globals.getInstance().WIFI_CONTROLLER.fill();
    }

    public void config() {
        DaemonReader.getInstance().stop();
        ModbusHelper.getInstance().disconnect();
        Globals.getInstance().AfficherBornePane.setDisable(true);
        Globals.getInstance().RacinePane.setCenter((Node)Globals.getInstance().ConfigurerBornePane);
        Globals.getInstance().CONFIG_CONTROLLER.fill();
    }

    public void forcage() {
        DaemonReader.getInstance().stop();
        ModbusHelper.getInstance().disconnect();
        Globals.getInstance().AfficherBornePane.setDisable(true);
        Globals.getInstance().RacinePane.setCenter((Node)Globals.getInstance().ConfigurerForcagePane);
        Globals.getInstance().FORCAGE_CONTROLLER.fill();
    }

    @FXML
    public void toogleConnect() {
        if (DaemonReader.getInstance().isRunning()) {
            DaemonReader.getInstance().stop();
        } else {
            DaemonReader.getInstance().start();
        }
    }

    private void disableContent(final boolean b) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                AfficherBorneController.this.mContent.setDisable(b);
                if (b) {
                    Object[] objectArray = AfficherBorneController.this.mCompteurs;
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AffichageControl compteur = objectArray[n2];
                        compteur.removeAllEnergie();
                        ++n2;
                    }
                    objectArray = AfficherBorneController.this.mEntrees;
                    n = objectArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        AffichageControl entree = objectArray[n2];
                        ((InOut)((Object)entree)).setValue(false);
                        ++n2;
                    }
                    objectArray = AfficherBorneController.this.mSorties;
                    n = objectArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        AffichageControl sortie = objectArray[n2];
                        ((InOut)((Object)sortie)).setValue(false);
                        ++n2;
                    }
                }
            }
        });
    }

    private String formatUnits(long units) {
        return this.NF.format(units);
    }

    @FXML
    public void initialize() {
        this.mCompteurs[0] = this.mAffichage1;
        this.mCompteurs[1] = this.mAffichage2;
        this.mCompteurs[2] = this.mAffichage3;
        this.mCompteurs[3] = this.mAffichage4;
        this.mCompteurs[4] = this.mAffichage5;
        this.mCompteurs[5] = this.mAffichage6;
        this.mCompteurs[6] = this.mAffichage7;
        this.mCompteurs[7] = this.mAffichage8;
        this.mEntrees[0] = new InOut(this.mE1);
        this.mEntrees[1] = new InOut(this.mE2);
        this.mEntrees[2] = new InOut(this.mE3);
        this.mEntrees[3] = new InOut(this.mE4);
        this.mSorties[0] = new InOut(this.mS1);
        this.mSorties[1] = new InOut(this.mS2);
        this.mSorties[2] = new InOut(this.mS3);
        this.mSorties[3] = new InOut(this.mS4);
        this.disableContent(true);
        int i = 0;
        while (i < 8) {
            if (i < 4) {
                this.mCompteurs[i].setEau(i);
            } else {
                this.mCompteurs[i].setElec(i);
            }
            ++i;
        }
        this.mVersionApp.setText("V1.0.1");
        DaemonReader.getInstance().addListener(this);
    }

    private void modbusState(final String s) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                AfficherBorneController.this.mConnect.getStyleClass().removeAll((Object[])new String[]{AfficherBorneController.CONNEXION_ON, AfficherBorneController.CONNEXION_OFF, AfficherBorneController.CONNEXION_ERREUR});
                AfficherBorneController.this.mConnect.getStyleClass().add((Object)s);
            }
        });
    }

    protected String getModeComptage(int fctBorne) {
        if (fctBorne == 1) {
            return "Comptage";
        }
        if (fctBorne == 2) {
            return "Temps";
        }
        if (fctBorne == 3) {
            return "PP";
        }
        return "??" + fctBorne + "??";
    }

    protected String getModeCarte(int fctCarte) {
        if (fctCarte == 1) {
            return "Borne";
        }
        if (fctCarte == 2) {
            return "Ponton";
        }
        if (fctCarte == 3) {
            return "Sanitaire";
        }
        if (fctCarte == 4) {
            return "Parking";
        }
        return "??" + fctCarte + "??";
    }

    public void sortir() {
        DaemonReader.getInstance().stop();
        Platform.exit();
        System.exit(0);
    }

    @Override
    public void statusChanged(DaemonReader.STATUS status) {
        switch (status) {
            case DISCONNECTED: {
                this.modbusState(CONNEXION_OFF);
                break;
            }
            case CONNECTED: {
                this.modbusState(CONNEXION_ON);
                break;
            }
            case ERROR: {
                this.modbusState(CONNEXION_ERREUR);
            }
        }
    }

    @Override
    public void statusReadedValues(final Values values) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                AfficherBorneController.this.disableContent(false);
                try {
                    AfficherBorneController.this.mVersion.setText("V : " + values.getVersion());
                    AfficherBorneController.this.mCarteId.setText("Carte : " + values.getCarteId());
                    AfficherBorneController.this.mModeCarte.setText(AfficherBorneController.this.getModeCarte(values.getModeCarte()));
                    AfficherBorneController.this.mModeComptage.setText(AfficherBorneController.this.getModeComptage(values.getModeComptage()));
                    AfficherBorneController.this.mModeComptage.setVisible(values.getModeCarte() == 1);
                    AfficherBorneController.this.mSlaveId.setText("Modbus : " + values.getSlaveId());
                    AfficherBorneController.this.mNumZone.setText("" + values.getNumZone());
                    AfficherBorneController.this.mNumZone.setVisible(values.getModeCarte() != 1);
                    int i = 0;
                    while (i < 8) {
                        AfficherBorneController.this.mCompteurs[i].setImpulsions(AfficherBorneController.this.formatUnits(values.getPrise(i).getCompteur()));
                        ++i;
                    }
                    i = 0;
                    while (i < 8) {
                        AfficherBorneController.this.mCompteurs[i].setUnits(AfficherBorneController.this.formatUnits(values.getPrise(i).getRestant()));
                        ++i;
                    }
                    i = 0;
                    while (i < 8) {
                        AfficherBorneController.this.mCompteurs[i].setRelais(values.getPrise(i).isRelais());
                        ++i;
                    }
                    i = 0;
                    while (i < 4) {
                        AfficherBorneController.this.mEntrees[i].setValue(values.getEntree(i));
                        ++i;
                    }
                    i = 0;
                    while (i < 4) {
                        AfficherBorneController.this.mSorties[i].setValue(values.getSortie(i));
                        ++i;
                    }
                    AfficherBorneController.this.mVoyantVert.getStyleClass().clear();
                    AfficherBorneController.this.mVoyantVert.getStyleClass().add((Object)(values.isVoyantVert() ? "voyant_vert_on" : "voyant_vert_off"));
                    AfficherBorneController.this.mVoyantRouge.getStyleClass().clear();
                    AfficherBorneController.this.mVoyantRouge.getStyleClass().add((Object)(values.isVoyantRouge() ? "voyant_rouge_on" : "voyant_rouge_off"));
                    i = 0;
                    while (i < 8) {
                        AfficherBorneController.this.mCompteurs[i].setVoyant(values.getPrise(i).isVoyant());
                        ++i;
                    }
                    NumberFormat tempFormatter = NumberFormat.getNumberInstance();
                    tempFormatter.setMaximumFractionDigits(1);
                    tempFormatter.setMinimumFractionDigits(1);
                    AfficherBorneController.this.mTemperature.setText(String.valueOf(tempFormatter.format((double)values.getTemperature() / 10.0)) + "\u00b0C");
                    long timestampDateHeure = values.getTimestampDateHeure();
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTimeInMillis(timestampDateHeure * 1000L);
                    SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/YYYY HH:mm:ss");
                    AfficherBorneController.this.mDate.setText(dateFormat.format(calendar.getTime()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private class InOut {
        private Label mLabel;

        public InOut(Label label) {
            this.mLabel = label;
        }

        public void setValue(boolean b) {
            this.mLabel.getStyleClass().removeAll((Object[])new String[]{AfficherBorneController.ES_ON, AfficherBorneController.ES_OFF});
            this.mLabel.getStyleClass().add((Object)(b ? AfficherBorneController.ES_ON : AfficherBorneController.ES_OFF));
        }
    }
}

