/*
 * Decompiled with CFR 0.152.
 */
package fr.iiprocess.marina.config;

import fr.iiprocess.marina.Globals;
import fr.iiprocess.marina.config.NumPadControl;
import fr.iiprocess.marina.model.Config;
import fr.iiprocess.marina.model.Values;
import fr.iiprocess.marina.serial.ModbusHelper;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class ConfigurerBorneController {
    private static final List<String> ELEC_PLUG_TYPES = Arrays.asList("Aucun", "Mono 16A", "Mono 32A", "Mono 63A", "Mono 125A", "T\u00e9tra 32A", "T\u00e9tra 63A", "T\u00e9tra 125A", "T\u00e9tra 250A", "T\u00e9tra 400A");
    private static final List<String> WATER_PLUG_TYPES = Arrays.asList("Aucun", "Robinet");
    @FXML
    private GridPane mGridPane;
    @FXML
    private ComboBox<String> mModeFct;
    @FXML
    private ComboBox<String> mModeBorne;
    @FXML
    private TextField mIDCard;
    @FXML
    private ComboBox<String> mIDComSlave;
    @FXML
    private TextField mNumZone;
    @FXML
    private TextField mIDLocation;
    private TextField[] mEchelles = new TextField[8];
    private ComboBox<String>[] mPlugTypes = new ComboBox[8];
    @FXML
    private ComboBox<Integer> mTVent;
    @FXML
    private ComboBox<Integer> mTChauff;
    @FXML
    private Button mOk;
    private NumPadControl mNumPadControl;
    private Stage mStage;

    @FXML
    public void restoreDefault() {
        String id = this.mIDCard.getText();
        this.mIDLocation.setText(id);
        this.mNumZone.setText(id);
        this.mIDComSlave.getSelectionModel().select(Integer.parseInt(id) - 1);
        this.mModeFct.getSelectionModel().select(1);
        this.mModeBorne.getSelectionModel().select(1);
        this.mTVent.getSelectionModel().select(9);
        this.mTChauff.getSelectionModel().select(2);
        int i = 0;
        while (i < this.mEchelles.length) {
            TextField echelle = this.mEchelles[i];
            echelle.setText(i < 4 ? "495" : "10");
            ++i;
        }
        i = 0;
        while (i < this.mPlugTypes.length) {
            ComboBox<String> plugType = this.mPlugTypes[i];
            plugType.getSelectionModel().select(1);
            ++i;
        }
    }

    @FXML
    public void back() {
        Globals.getInstance().RacinePane.setCenter((Node)Globals.getInstance().AfficherBornePane);
        Globals.getInstance().AfficherBornePane.setDisable(false);
    }

    private void createPlug(GridPane gridPane, int pos) {
        int row = pos % 4 + 5;
        int col = pos / 4 == 0 ? 2 : 0;
        HBox hBox = new HBox();
        System.out.println(String.valueOf(pos) + " : " + row + ", " + col);
        Label label = new Label("" + (row - 4));
        label.setAlignment(Pos.BASELINE_LEFT);
        TextField button = new TextField("");
        button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                ConfigurerBorneController.this.changeValue(event);
            }
        });
        button.setText(pos / 4 == 0 ? "10" : "495");
        button.setMaxWidth(150.0);
        this.mEchelles[pos] = button;
        ComboBox cb = new ComboBox();
        cb.getItems().addAll(pos / 4 == 0 ? WATER_PLUG_TYPES : ELEC_PLUG_TYPES);
        this.mPlugTypes[pos] = cb;
        HBox.setMargin((Node)label, (Insets)new Insets(0.0, 30.0, 0.0, 0.0));
        hBox.getChildren().add((Object)label);
        hBox.getChildren().add((Object)button);
        hBox.getChildren().add((Object)cb);
        GridPane.setRowIndex((Node)hBox, (Integer)row);
        GridPane.setColumnIndex((Node)hBox, (Integer)col);
        GridPane.setColumnSpan((Node)hBox, (Integer)3);
        this.mGridPane.getChildren().add((Object)hBox);
    }

    @FXML
    public void initialize() {
        int i = 0;
        while (i < this.mEchelles.length) {
            this.createPlug(this.mGridPane, i);
            ++i;
        }
        i = 1;
        while (i <= 255) {
            this.mIDComSlave.getItems().add((Object)Integer.toString(i));
            ++i;
        }
        this.mIDComSlave.getSelectionModel().selectFirst();
        this.mOk.setDisable(false);
    }

    @FXML
    public void write() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Values values = new Values();
                try {
                    values.fillMetrics(ModbusHelper.getInstance().readMetrics());
                }
                catch (Exception e1) {
                    Alert alert = new Alert(Alert.AlertType.ERROR);
                    alert.setTitle("Erreur");
                    alert.setHeaderText("Impossible de lire la configuration\n" + e1.getMessage());
                    alert.setContentText("");
                    alert.showAndWait();
                    e1.printStackTrace();
                    return;
                }
                Config config = new Config();
                config.setIDCard(Short.parseShort(ConfigurerBorneController.this.mIDCard.getText()));
                config.setIDLocalisation(Short.parseShort(ConfigurerBorneController.this.mIDLocation.getText()));
                config.setModeFct((byte)ConfigurerBorneController.this.mModeFct.getSelectionModel().getSelectedIndex());
                config.setModeBorne((byte)ConfigurerBorneController.this.mModeBorne.getSelectionModel().getSelectedIndex());
                config.setIDComSlave((byte)(ConfigurerBorneController.this.mIDComSlave.getSelectionModel().getSelectedIndex() + 1));
                config.setNumZone(Byte.parseByte(ConfigurerBorneController.this.mNumZone.getText()));
                config.setTempVentilo((Integer)ConfigurerBorneController.this.mTVent.getSelectionModel().getSelectedItem());
                config.setTempChauffage((Integer)ConfigurerBorneController.this.mTChauff.getSelectionModel().getSelectedItem());
                int i = 0;
                while (i < ConfigurerBorneController.this.mEchelles.length) {
                    TextField echelle = ConfigurerBorneController.this.mEchelles[i];
                    config.setEchelle(i, Float.parseFloat(echelle.getText()));
                    System.out.println("=>" + i + " : " + Float.parseFloat(echelle.getText()));
                    ++i;
                }
                i = 0;
                while (i < ConfigurerBorneController.this.mPlugTypes.length) {
                    ComboBox plugType = ConfigurerBorneController.this.mPlugTypes[i];
                    config.setPlugType(i, (byte)plugType.getSelectionModel().getSelectedIndex());
                    System.out.println(String.valueOf(i) + " : " + (byte)plugType.getSelectionModel().getSelectedIndex());
                    ++i;
                }
                Calendar calendar = Calendar.getInstance();
                config.setTimestampDateHeure(calendar.getTimeInMillis() / 1000L);
                config.setForcageSInt(values.getForcageSInt());
                config.setForcageSExt(values.getForcageSExt());
                config.setForcageSVoy(values.getForcageSVoy());
                config.setForcageInitEnergie(values.getForcageInitEnergie());
                config.setEnergieHS(values.getEnergieHS());
                ModbusHelper modbus = ModbusHelper.getInstance();
                try {
                    modbus.write(8192, config.getByteBuffer());
                    int nbErrorsAllowed = 5;
                    StringBuffer sb = null;
                    while (nbErrorsAllowed > 0) {
                        ByteBuffer buffer = modbus.readMetrics();
                        values = new Values();
                        values.fillMetrics(buffer);
                        sb = new StringBuffer();
                        if (values.getCarteId() != config.getIDCard()) {
                            sb.append("Id carte pas \u00e9crit\n");
                        }
                        if (values.getModeCarte() != config.getModeFct()) {
                            sb.append("Mode fonctionnement pas \u00e9crit\n");
                        }
                        if (values.getModeComptage() != config.getModeBorne()) {
                            sb.append("Mode borne pas \u00e9crit\n");
                        }
                        if ((byte)values.getSlaveId() != (byte)config.getIDComSlave()) {
                            System.out.println(String.valueOf(values.getSlaveId()) + " : " + config.getIDComSlave());
                            sb.append("ID Esclave Modbus pas \u00e9crit\n");
                        }
                        if (values.getNumZone() != config.getNumZone()) {
                            sb.append("N\u00b0 Zone Acc\u00e8s pas \u00e9crit\n");
                        }
                        if (values.getTempVentilo() != config.getTempVentilo()) {
                            sb.append("T\u00b0 Ventilateur pas \u00e9crit\n");
                        }
                        if (values.getTempChauffage() != config.getTempChauffage()) {
                            sb.append("T\u00b0 Chauffage pas \u00e9crit\n");
                        }
                        int i2 = 0;
                        while (i2 < ConfigurerBorneController.this.mEchelles.length) {
                            if (values.getEchelle(i2) != config.getEchelle(i2)) {
                                sb.append("Echelle pas \u00e9crit\n");
                            }
                            ++i2;
                        }
                        i2 = 0;
                        while (i2 < ConfigurerBorneController.this.mPlugTypes.length) {
                            if (values.getPlugType(i2) != config.getPlugType(i2)) {
                                sb.append("Type de prise pas \u00e9crit\n");
                            }
                            ++i2;
                        }
                        if (sb.length() == 0) break;
                        --nbErrorsAllowed;
                        Thread.sleep(250L);
                    }
                    if (sb.length() > 0) {
                        throw new Exception(sb.toString());
                    }
                    Globals.getInstance().AfficherBornePane.setDisable(false);
                    Globals.getInstance().ROOT_CONTROLLER.displayAndConnect();
                }
                catch (Exception e) {
                    Alert alert = new Alert(Alert.AlertType.ERROR);
                    alert.setTitle("Erreur");
                    alert.setHeaderText("Impossible d'\u00e9crire les param\u00e8tres\n" + e.getMessage());
                    alert.setContentText("V\u00e9rifiez que le cable est branch\u00e9 et que DIP 8 = 0");
                    alert.showAndWait();
                    e.printStackTrace();
                }
            }
        });
    }

    @FXML
    public void changeValue(ActionEvent e) {
        int value;
        this.initNumPadControl();
        this.mNumPadControl.clear();
        this.mStage.showAndWait();
        if (this.mNumPadControl.isOk() && (value = this.mNumPadControl.getV()) > 0) {
            ((Button)e.getSource()).setText(Integer.toString(value));
        }
    }

    private void initNumPadControl() {
        if (this.mNumPadControl == null) {
            this.mNumPadControl = new NumPadControl();
            this.mStage = new Stage();
            this.mNumPadControl.getStylesheets().add((Object)this.getClass().getResource("/fr/iiprocess/marina/resources/application.css").toExternalForm());
            this.mStage.setScene(new Scene((Parent)this.mNumPadControl));
            this.mStage.initOwner(this.mOk.getScene().getWindow());
            this.mStage.initStyle(StageStyle.UNDECORATED);
            this.mStage.initModality(Modality.WINDOW_MODAL);
        }
    }

    public void fill() {
        Values values = new Values();
        try {
            values.fillMetrics(ModbusHelper.getInstance().readMetrics());
        }
        catch (Exception e) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Erreur");
            alert.setHeaderText("Impossible de lire la configuration\n" + e.getMessage());
            alert.setContentText("");
            alert.showAndWait();
            e.printStackTrace();
        }
        this.mModeFct.getSelectionModel().select(values.getModeCarte());
        this.mModeBorne.getSelectionModel().select(values.getModeComptage());
        this.mIDCard.setText("" + values.getCarteId());
        System.out.println(values.getSlaveId());
        this.mIDComSlave.getSelectionModel().select(values.getSlaveId() - 1);
        this.mNumZone.setText("" + values.getNumZone());
        this.mIDLocation.setText("" + values.getIdLocalisation());
        this.mTVent.getSelectionModel().select((Object)new Integer(values.getTempVentilo()));
        this.mTChauff.getSelectionModel().select((Object)new Integer(values.getTempChauffage()));
        int i = 0;
        while (i < this.mEchelles.length) {
            this.mEchelles[i].setText("" + values.getEchelle(i));
            ++i;
        }
        i = 0;
        while (i < this.mPlugTypes.length) {
            this.mPlugTypes[i].getSelectionModel().select((int)values.getPlugType(i));
            ++i;
        }
    }
}

