/*
 * Decompiled with CFR 0.152.
 */
package fr.iiprocess.marina.config;

import fr.iiprocess.marina.Globals;
import fr.iiprocess.marina.model.Config;
import fr.iiprocess.marina.model.Values;
import fr.iiprocess.marina.serial.ModbusHelper;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.GridPane;

public class ConfigurerForcageController {
    @FXML
    private GridPane mGridPane;
    @FXML
    private Button mOk;
    private static final String ForcageSInt = "Forcage Sorties Internes";
    private static final String ForcageSExt = "Forcage Relais";
    private static final String ForcageSVoy = "Forcage Voyants";
    private static final String ForcageInitEnergie = "R\u00e9initialiser";
    private static final String EnergieHS = "Distribution HS";
    private Forcage mForcageSInt;
    private Forcage mForcageSExt;
    private Forcage mForcageSVoy;
    private Forcage mForcageInitEnergie;
    private Forcage mEnergieHS;

    @FXML
    public void back() {
        Globals.getInstance().RacinePane.setCenter((Node)Globals.getInstance().AfficherBornePane);
        Globals.getInstance().AfficherBornePane.setDisable(false);
    }

    private void createLabels(GridPane gridPane, int row, String[] labels) {
        int i = 0;
        String[] stringArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            Label l = new Label(label);
            GridPane.setRowIndex((Node)l, (Integer)row);
            GridPane.setColumnIndex((Node)l, (Integer)i);
            gridPane.getChildren().add((Object)l);
            ++i;
            ++n2;
        }
    }

    private List<CheckBox> createCheckBoxs(final String action, GridPane gridPane, String label, final int row, int nb) {
        ArrayList<CheckBox> result = new ArrayList<CheckBox>();
        this.createLabels(gridPane, row, new String[]{label});
        int i = 1;
        while (i <= nb) {
            CheckBox c = new CheckBox();
            GridPane.setRowIndex((Node)c, (Integer)row);
            GridPane.setColumnIndex((Node)c, (Integer)i);
            gridPane.getChildren().add((Object)c);
            final int indice = i - 1;
            c.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    System.out.println(String.valueOf(action) + ", " + row + ", " + indice);
                }
            });
            result.add(c);
            ++i;
        }
        return result;
    }

    private Forcage createForcage(String action, GridPane parent, int row, int col, String title, String[] labels, boolean createValues) {
        TitledPane titlePane = new TitledPane();
        titlePane.setText(title);
        titlePane.setCollapsible(true);
        titlePane.setMaxWidth(Double.MAX_VALUE);
        titlePane.setMaxHeight(Double.MAX_VALUE);
        titlePane.setPrefWidth(930.0);
        GridPane gridPane = new GridPane();
        gridPane.setMaxWidth(Double.MAX_VALUE);
        gridPane.setMaxHeight(Double.MAX_VALUE);
        gridPane.setHgap(10.0);
        gridPane.setVgap(10.0);
        this.createLabels(gridPane, 0, labels);
        List<CheckBox> forcages = this.createCheckBoxs(action, gridPane, "For\u00e7age", 1, labels.length - 1);
        ArrayList<CheckBox> values = new ArrayList();
        if (createValues) {
            values = this.createCheckBoxs(action, gridPane, "Valeur", 2, labels.length - 1);
        }
        titlePane.setContent((Node)gridPane);
        GridPane.setRowIndex((Node)titlePane, (Integer)row);
        GridPane.setColumnIndex((Node)titlePane, (Integer)col);
        parent.getChildren().add((Object)titlePane);
        return new Forcage(forcages, values);
    }

    @FXML
    public void initialize() {
        this.mForcageSInt = this.createForcage(ForcageSInt, this.mGridPane, 0, 0, ForcageSInt, new String[]{"#", "INT_1", "INT_2", "INT_3", "INT_4", "BUZZ", "Vert", "Rouge", "8"}, true);
        this.mForcageSExt = this.createForcage(ForcageSExt, this.mGridPane, 1, 0, ForcageSExt, new String[]{"#", "EAU_1", "EAU_2", "EAU_3", "EAU_4", "ELEC_1", "ELEC_2", "ELEC_3", "ELEC_4"}, true);
        this.mForcageSVoy = this.createForcage(ForcageSVoy, this.mGridPane, 2, 0, ForcageSVoy, new String[]{"#", "EAU_1", "EAU_2", "EAU_3", "EAU_4", "ELEC_1", "ELEC_2", "ELEC_3", "ELEC_4"}, true);
        this.mForcageInitEnergie = this.createForcage(ForcageInitEnergie, this.mGridPane, 3, 0, ForcageInitEnergie, new String[]{"#", "EAU_1", "EAU_2", "EAU_3", "EAU_4", "ELEC_1", "ELEC_2", "ELEC_3", "ELEC_4"}, true);
        this.mEnergieHS = this.createForcage(EnergieHS, this.mGridPane, 4, 0, EnergieHS, new String[]{"#", "EAU_1", "EAU_2", "EAU_3", "EAU_4", "ELEC_1", "ELEC_2", "ELEC_3", "ELEC_4"}, false);
    }

    @FXML
    public void write() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Values values = new Values();
                try {
                    values.fillMetrics(ModbusHelper.getInstance().readMetrics());
                }
                catch (Exception e1) {
                    Alert alert = new Alert(Alert.AlertType.ERROR);
                    alert.setTitle("Erreur");
                    alert.setHeaderText("Impossible de lire la configuration\n" + e1.getMessage());
                    alert.setContentText("");
                    alert.showAndWait();
                    e1.printStackTrace();
                    return;
                }
                Config config = new Config();
                config.setIDCard(values.getCarteId());
                config.setModeFct(values.getModeCarte());
                config.setModeBorne(values.getModeComptage());
                config.setIDComSlave(values.getSlaveId());
                config.setIDLocalisation(values.getIdLocalisation());
                config.setNumZone(values.getNumZone());
                config.setTempVentilo(values.getTempVentilo());
                config.setTempChauffage(values.getTempChauffage());
                int i = 0;
                while (i < values.getEchelles().length) {
                    config.setEchelle(i, values.getEchelle(i));
                    ++i;
                }
                i = 0;
                while (i < values.getPlugTypes().length) {
                    config.setPlugType(i, values.getPlugType(i));
                    ++i;
                }
                Calendar calendar = Calendar.getInstance();
                config.setTimestampDateHeure(calendar.getTimeInMillis() / 1000L);
                config.setForcageSInt(ConfigurerForcageController.this.mForcageSInt.getValue());
                config.setForcageSExt(ConfigurerForcageController.this.mForcageSExt.getValue());
                config.setForcageSVoy(ConfigurerForcageController.this.mForcageSVoy.getValue());
                config.setForcageInitEnergie(ConfigurerForcageController.this.mForcageInitEnergie.getValue());
                config.setEnergieHS(ConfigurerForcageController.this.mEnergieHS.getByteValue());
                ModbusHelper modbus = ModbusHelper.getInstance();
                if (values.getForcageInitEnergie() != config.getForcageInitEnergie()) {
                    Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                    alert.setTitle("Attention");
                    alert.setHeaderText("Des cr\u00e9dits peuvent \u00eatre perdus!");
                    alert.setContentText("L'initialisation d'un prise entraine la perte des cr\u00e9dits pour une carte pr\u00e9charg\u00e9e et la perte des consommations pour un carte post paiement.\nVoulez vous continuer et risquer la perte de cr\u00e9dits?");
                    Optional ret = alert.showAndWait();
                    if (ret.get() == ButtonType.CANCEL) {
                        ConfigurerForcageController.this.mForcageInitEnergie.setValue(values.getForcageInitEnergie());
                        Globals.getInstance().AfficherBornePane.setDisable(false);
                        Globals.getInstance().ROOT_CONTROLLER.displayAndConnect();
                        return;
                    }
                }
                try {
                    modbus.write(8192, config.getByteBuffer());
                    int nbErrorsAllowed = 5;
                    StringBuffer sb = null;
                    while (nbErrorsAllowed > 0) {
                        ByteBuffer buffer = modbus.readMetrics();
                        values = new Values();
                        values.fillMetrics(buffer);
                        sb = new StringBuffer();
                        if (values.getForcageSInt() != config.getForcageSInt()) {
                            sb.append("ForcageSInt pas \u00e9crit\n");
                        }
                        if (values.getForcageSExt() != config.getForcageSExt()) {
                            sb.append("ForcageSEx pas \u00e9crit\n");
                        }
                        if (values.getForcageSVoy() != config.getForcageSVoy()) {
                            sb.append("ForcageSVoy pas \u00e9crit\n");
                        }
                        if (values.getEnergieHS() != config.getEnergieHS()) {
                            sb.append("EnergieHS pas \u00e9crit\n");
                        }
                        if (sb.length() == 0) break;
                        --nbErrorsAllowed;
                        Thread.sleep(100L);
                    }
                    if (sb.length() > 0) {
                        throw new Exception(sb.toString());
                    }
                    Globals.getInstance().AfficherBornePane.setDisable(false);
                    Globals.getInstance().ROOT_CONTROLLER.displayAndConnect();
                }
                catch (Exception e) {
                    Alert alert = new Alert(Alert.AlertType.ERROR);
                    alert.setTitle("Erreur");
                    alert.setHeaderText("Impossible d'\u00e9crire les param\u00e8tres\n" + e.getMessage());
                    alert.setContentText("V\u00e9rifiez que le cable est branch\u00e9 et que DIP 8 = 0");
                    alert.showAndWait();
                    e.printStackTrace();
                }
            }
        });
    }

    public void fill() {
        Values values = new Values();
        try {
            values.fillMetrics(ModbusHelper.getInstance().readMetrics());
        }
        catch (Exception e) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Erreur");
            alert.setHeaderText("Impossible de lire la configuration\n" + e.getMessage());
            alert.setContentText("");
            alert.showAndWait();
            e.printStackTrace();
        }
        this.mForcageSInt.setValue(values.getForcageSInt());
        this.mForcageSExt.setValue(values.getForcageSExt());
        this.mForcageSVoy.setValue(values.getForcageSVoy());
        this.mForcageInitEnergie.setValue(values.getForcageInitEnergie());
        this.mEnergieHS.setValue(values.getEnergieHS());
    }

    private static class Forcage {
        private List<CheckBox> mForcages;
        private List<CheckBox> mValues;

        public Forcage(List<CheckBox> forcages, List<CheckBox> values) {
            this.mForcages = forcages;
            this.mValues = values;
        }

        public int getValue() {
            int result = 0;
            int i = 0;
            while (i < 8) {
                if (this.mForcages.get(i).isSelected()) {
                    result += 1 << i;
                }
                if (this.mValues.get(i).isSelected()) {
                    result += 1 << 8 + i;
                }
                ++i;
            }
            return result;
        }

        public void setValue(int value) {
            int i = 0;
            while (i < 8) {
                if (i < this.mForcages.size()) {
                    this.mForcages.get(i).setSelected((value & 1 << i) != 0);
                }
                if (i < this.mValues.size()) {
                    this.mValues.get(i).setSelected((value & 1 << 8 + i) != 0);
                }
                ++i;
            }
        }

        public short getByteValue() {
            short result = 0;
            int i = 0;
            while (i < 8) {
                if (this.mForcages.get(i).isSelected()) {
                    result = (short)(result + (1 << i));
                }
                ++i;
            }
            return result;
        }
    }
}

