/*
 * Decompiled with CFR 0.152.
 */
package fr.iiprocess.marina.config;

import fr.iiprocess.marina.Globals;
import fr.iiprocess.marina.model.Values;
import fr.iiprocess.marina.serial.ModbusHelper;
import java.nio.ByteBuffer;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;

public class ConfigurerWifiController {
    @FXML
    private GridPane mGridPane;
    @FXML
    private CheckBox mEnableWifi;
    @FXML
    private TextField mSSIDWifi;
    @FXML
    private TextField mKeyWifi;
    @FXML
    private TextField mDestIp;
    @FXML
    private TextField mDestPort;
    @FXML
    private CheckBox mDHCPWifi;
    @FXML
    private TextField mConfIpWifi;
    @FXML
    private TextField mConfSubnetWifi;
    @FXML
    private TextField mConfGatewayWifi;
    @FXML
    private TextField mNFCKey;
    @FXML
    private Button mOk;

    @FXML
    public void back() {
        Globals.getInstance().RacinePane.setCenter((Node)Globals.getInstance().AfficherBornePane);
        Globals.getInstance().AfficherBornePane.setDisable(false);
    }

    @FXML
    public void initialize() {
        this.mOk.setDisable(false);
    }

    private short[] nfcKeyToArray(String nfcKey) {
        short[] res = new short[6];
        String[] parts = nfcKey.split("-");
        int i = 0;
        while (i < 6) {
            res[i] = Short.parseShort(parts[i], 16);
            ++i;
        }
        return res;
    }

    private short[] ipToArray(String ip) {
        short[] res = new short[4];
        String[] parts = ip.split("\\.");
        int i = 0;
        while (i < 4) {
            res[i] = Short.parseShort(parts[i]);
            ++i;
        }
        return res;
    }

    @FXML
    public void write() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Values newValues = new Values();
                newValues.setEnableWifi(ConfigurerWifiController.this.mEnableWifi.selectedProperty().get());
                newValues.setSSIDWifi(ConfigurerWifiController.this.mSSIDWifi.getText());
                newValues.setKeyWifi(ConfigurerWifiController.this.mKeyWifi.getText());
                newValues.setDestIp(ConfigurerWifiController.this.ipToArray(ConfigurerWifiController.this.mDestIp.getText()));
                newValues.setDestPort(Integer.parseInt(ConfigurerWifiController.this.mDestPort.getText()));
                newValues.setDHCPWifi(ConfigurerWifiController.this.mDHCPWifi.selectedProperty().get());
                newValues.setConfIpWifi(ConfigurerWifiController.this.ipToArray(ConfigurerWifiController.this.mConfIpWifi.getText()));
                newValues.setConfSubnetWifi(ConfigurerWifiController.this.ipToArray(ConfigurerWifiController.this.mConfSubnetWifi.getText()));
                newValues.setConfGatewayWifi(ConfigurerWifiController.this.ipToArray(ConfigurerWifiController.this.mConfGatewayWifi.getText()));
                newValues.setNFCKey(ConfigurerWifiController.this.nfcKeyToArray(ConfigurerWifiController.this.mNFCKey.getText()));
                ModbusHelper modbus = ModbusHelper.getInstance();
                try {
                    System.out.println("write: 8225");
                    modbus.write(8225, newValues.getWifiByteBuffer());
                    int nbErrorsAllowed = 5;
                    StringBuffer sb = null;
                    while (nbErrorsAllowed > 0) {
                        Thread.sleep(500L);
                        ByteBuffer buffer = modbus.readWifi();
                        Values readValues = new Values();
                        readValues.fillWifi(buffer);
                        sb = new StringBuffer();
                        if (readValues.isEnableWifi() != newValues.isEnableWifi()) {
                            sb.append("Wifi activ\u00e9 pas \u00e9crit\n");
                        }
                        System.out.println("ici1: " + readValues.getSSIDWifi());
                        System.out.println("ici2: " + newValues.getSSIDWifi());
                        if (!readValues.getSSIDWifi().equals(newValues.getSSIDWifi())) {
                            sb.append("SSID pas \u00e9crit\n");
                        }
                        System.out.println("la1: " + readValues.getKeyWifi());
                        System.out.println("la2: " + newValues.getKeyWifi());
                        if (!readValues.getKeyWifi().equals(newValues.getKeyWifi())) {
                            sb.append("Cl\u00e9 pas \u00e9crite\n");
                        }
                        int i = 0;
                        while (i < 4) {
                            if (readValues.getDestIp()[i] != newValues.getDestIp()[i]) {
                                sb.append("IP destination pas \u00e9crite\n");
                                break;
                            }
                            ++i;
                        }
                        if (readValues.getDestPort() != newValues.getDestPort()) {
                            sb.append("Port destination pas \u00e9crit\n");
                        }
                        if (readValues.isDHCPWifi() != newValues.isDHCPWifi()) {
                            sb.append("DHCP activ\u00e9 pas \u00e9crit\n");
                        }
                        i = 0;
                        while (i < 4) {
                            if (readValues.getConfIpWifi()[i] != newValues.getConfIpWifi()[i]) {
                                sb.append("IP statique pas \u00e9crite\n");
                                break;
                            }
                            ++i;
                        }
                        i = 0;
                        while (i < 4) {
                            if (readValues.getConfSubnetWifi()[i] != newValues.getConfSubnetWifi()[i]) {
                                sb.append("Masque pas \u00e9crit\n");
                                break;
                            }
                            ++i;
                        }
                        i = 0;
                        while (i < 4) {
                            if (readValues.getConfGatewayWifi()[i] != newValues.getConfGatewayWifi()[i]) {
                                sb.append("Passerelle pas \u00e9crite\n");
                                break;
                            }
                            ++i;
                        }
                        i = 0;
                        while (i < 6) {
                            if (readValues.getNFCKey()[i] != newValues.getNFCKey()[i]) {
                                sb.append("Cl\u00e9 NFC pas \u00e9crite\n");
                                break;
                            }
                            ++i;
                        }
                        if (sb.length() == 0) break;
                        --nbErrorsAllowed;
                        Thread.sleep(100L);
                    }
                    if (sb.length() > 0) {
                        throw new Exception(sb.toString());
                    }
                    Globals.getInstance().AfficherBornePane.setDisable(false);
                    Globals.getInstance().ROOT_CONTROLLER.displayAndConnect();
                }
                catch (Exception e) {
                    Alert alert = new Alert(Alert.AlertType.ERROR);
                    alert.setTitle("Erreur");
                    alert.setHeaderText("Impossible d'\u00e9crire les param\u00e8tres\n" + e.getMessage());
                    alert.showAndWait();
                    e.printStackTrace();
                }
            }
        });
    }

    private String getStringIp(short[] ip) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < ip.length) {
            if (i > 0) {
                sb.append(".");
            }
            sb.append(ip[i]);
            ++i;
        }
        return sb.toString();
    }

    private String byteToHex(byte num) {
        char[] hexDigits = new char[]{Character.forDigit(num >> 4 & 0xF, 16), Character.forDigit(num & 0xF, 16)};
        return new String(hexDigits);
    }

    private String getStringNFCKey(short[] key) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < key.length) {
            if (i > 0) {
                sb.append("-");
            }
            sb.append(this.byteToHex((byte)(key[i] & 0xFF)));
            ++i;
        }
        return sb.toString();
    }

    public void fill() {
        ModbusHelper modbus = ModbusHelper.getInstance();
        try {
            ByteBuffer buffer = modbus.readWifi();
            Values values = new Values();
            values.fillWifi(buffer);
            this.mEnableWifi.selectedProperty().set(values.isEnableWifi());
            this.mSSIDWifi.setText(values.getSSIDWifi());
            this.mKeyWifi.setText(values.getKeyWifi());
            this.mDestIp.setText(this.getStringIp(values.getDestIp()));
            this.mDestPort.setText(Integer.toString(values.getDestPort()));
            this.mDHCPWifi.selectedProperty().set(values.isDHCPWifi());
            this.mConfIpWifi.setText(this.getStringIp(values.getConfIpWifi()));
            this.mConfSubnetWifi.setText(this.getStringIp(values.getConfSubnetWifi()));
            this.mConfGatewayWifi.setText(this.getStringIp(values.getConfGatewayWifi()));
            this.mNFCKey.setText(this.getStringNFCKey(values.getNFCKey()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

