/*
 * Decompiled with CFR 0.152.
 */
package fr.iiprocess.marina.config;

import fr.iiprocess.marina.Globals;
import fr.iiprocess.marina.serial.ModbusHelper;
import gnu.io.CommPortIdentifier;
import java.util.Enumeration;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;

public class ConnexionController {
    static final int SLAVE_ID = 1;
    @FXML
    private ComboBox<String> mPort;
    @FXML
    private Button mOk;

    @FXML
    public void initialize() {
        this.mPort.getItems().clear();
        this.refreshSerialComs();
        this.mOk.setDisable(false);
    }

    @FXML
    public void refresh() {
        this.refreshSerialComs();
    }

    public void refreshSerialComs() {
        Enumeration<CommPortIdentifier> portEnum = CommPortIdentifier.getPortIdentifiers();
        this.mPort.getItems().clear();
        while (portEnum.hasMoreElements()) {
            CommPortIdentifier portIdentifier = portEnum.nextElement();
            if (portIdentifier.getPortType() != 1) continue;
            this.mPort.getItems().add((Object)portIdentifier.getName());
        }
        this.mPort.getSelectionModel().selectFirst();
    }

    @FXML
    public void connect() {
        ModbusHelper modbusHelper = ModbusHelper.getInstance();
        modbusHelper.setPortname((String)this.mPort.getValue());
        modbusHelper.setSlaveId(1);
        try {
            Globals.getInstance().ROOT_CONTROLLER.displayAndConnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void exit() {
        ModbusHelper.getInstance().disconnect();
        System.exit(0);
    }
}

