/*
 * Decompiled with CFR 0.152.
 */
package fr.iiprocess.marina.model;

import fr.iiprocess.marina.model.Prise;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Values {
    public static final int NB_PRISES = 8;
    public static final int NB_ENTREES = 4;
    public static final int NB_SORTIES = 4;
    private int mVersion;
    private int mCarteId;
    private int idLocalisation;
    private int mModeCarte;
    private int mModeComptage;
    private int mSlaveId;
    private int mNumZone;
    private Prise[] mPrises = new Prise[8];
    private boolean[] mEntrees = new boolean[4];
    private boolean[] mSorties = new boolean[4];
    private boolean mVoyantVert;
    private boolean mVoyantRouge;
    private int mTemperature;
    private EtatEnergie[] mEtatEnergies = new EtatEnergie[8];
    private int mForcageSInt;
    private int mForcageSExt;
    private int mForcageSVoy;
    private int mForcageInitEnergie;
    private long mTimestampDateHeure;
    private int mTempVentilo;
    private int mTempChauffage;
    private float[] mEchelles = new float[8];
    private byte[] mPlugTypes = new byte[8];
    private short mEnergieHS;
    private boolean mEnableWifi;
    private String mSSIDWifi;
    private String mKeyWifi;
    private boolean mDHCPWifi;
    private short[] mConfIpWifi = new short[4];
    private short[] mCongSubnetWifi = new short[4];
    private short[] mConfGatewayWifi = new short[4];
    private short[] mNFCKey = new short[6];
    private short[] mDestIp = new short[4];
    private int mDestPort;

    public ByteBuffer getWifiByteBuffer() {
        int NB_WORDS = 48;
        byte[] bytes = new byte[2 * NB_WORDS];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put((byte)(this.mEnableWifi ? 1 : 0));
        int i = 0;
        while (i < 32) {
            if (this.mSSIDWifi != null && i < this.mSSIDWifi.length()) {
                byteBuffer.put((byte)this.mSSIDWifi.charAt(i));
            } else {
                byteBuffer.put((byte)0);
            }
            ++i;
        }
        i = 0;
        while (i < 32) {
            if (this.mKeyWifi != null && i < this.mKeyWifi.length()) {
                byteBuffer.put((byte)this.mKeyWifi.charAt(i));
            } else {
                byteBuffer.put((byte)0);
            }
            ++i;
        }
        byteBuffer.put((byte)(this.mDHCPWifi ? 1 : 0));
        i = 0;
        while (i < 4) {
            byteBuffer.put((byte)this.mConfIpWifi[i]);
            ++i;
        }
        i = 0;
        while (i < 4) {
            byteBuffer.put((byte)this.mCongSubnetWifi[i]);
            ++i;
        }
        i = 0;
        while (i < 4) {
            byteBuffer.put((byte)this.mConfGatewayWifi[i]);
            ++i;
        }
        i = 0;
        while (i < 4) {
            byteBuffer.put((byte)this.mDestIp[i]);
            ++i;
        }
        byteBuffer.putShort((short)this.mDestPort);
        i = 0;
        while (i < 6) {
            byteBuffer.put((byte)this.mNFCKey[i]);
            ++i;
        }
        return byteBuffer;
    }

    public void fillWifi(ByteBuffer byteBuffer) {
        this.mEnableWifi = Values.readUnsignedByte(byteBuffer) != 0;
        this.mSSIDWifi = Values.readString(byteBuffer, 32);
        this.mKeyWifi = Values.readString(byteBuffer, 32);
        this.mDHCPWifi = Values.readUnsignedByte(byteBuffer) != 0;
        int i = 0;
        while (i < 4) {
            this.mConfIpWifi[i] = Values.readUnsignedByte(byteBuffer);
            ++i;
        }
        i = 0;
        while (i < 4) {
            this.mCongSubnetWifi[i] = Values.readUnsignedByte(byteBuffer);
            ++i;
        }
        i = 0;
        while (i < 4) {
            this.mConfGatewayWifi[i] = Values.readUnsignedByte(byteBuffer);
            ++i;
        }
        i = 0;
        while (i < 4) {
            this.mDestIp[i] = Values.readUnsignedByte(byteBuffer);
            ++i;
        }
        this.mDestPort = Values.readUnsignedShort(byteBuffer);
        i = 0;
        while (i < 6) {
            this.mNFCKey[i] = Values.readUnsignedByte(byteBuffer);
            ++i;
        }
    }

    public void fillMetrics(ByteBuffer byteBuffer) {
        long val;
        this.mVersion = Values.readUnsignedShort(byteBuffer);
        this.mCarteId = Values.readUnsignedShort(byteBuffer);
        this.idLocalisation = Values.readUnsignedShort(byteBuffer);
        this.mModeCarte = Values.readUnsignedByte(byteBuffer);
        this.mModeComptage = Values.readUnsignedByte(byteBuffer);
        this.mSlaveId = Values.readUnsignedByte(byteBuffer);
        this.mNumZone = Values.readUnsignedByte(byteBuffer);
        int i = 0;
        while (i < 8) {
            this.mPrises[i] = new Prise();
            val = Values.readUnsignedInt(byteBuffer);
            this.mPrises[i].setCompteur(val);
            ++i;
        }
        i = 0;
        while (i < 8) {
            val = Values.readUnsignedInt(byteBuffer);
            this.mPrises[i].setRestant(val);
            ++i;
        }
        short relais = Values.readUnsignedByte(byteBuffer);
        int i2 = 0;
        while (i2 < 8) {
            this.mPrises[i2].setRelais((relais & 1 << i2) != 0);
            ++i2;
        }
        short etors = Values.readUnsignedByte(byteBuffer);
        int i3 = 0;
        while (i3 < 4) {
            this.mEntrees[i3] = (etors & 1 << i3) != 0;
            ++i3;
        }
        short stors = Values.readUnsignedByte(byteBuffer);
        int i4 = 0;
        while (i4 < 4) {
            this.mSorties[i4] = (stors & 1 << i4) != 0;
            ++i4;
        }
        short voyantVR = Values.readUnsignedByte(byteBuffer);
        this.mVoyantVert = (voyantVR & 1) != 0;
        this.mVoyantRouge = (voyantVR & 2) != 0;
        short voyants = Values.readUnsignedByte(byteBuffer);
        int i5 = 0;
        while (i5 < 8) {
            this.mPrises[i5].setVoyant((voyants & 1 << i5) != 0);
            ++i5;
        }
        Values.readUnsignedByte(byteBuffer);
        this.mTemperature = Values.readUnsignedShort(byteBuffer);
        i5 = 0;
        while (i5 < 8) {
            this.mEtatEnergies[i5] = new EtatEnergie();
            int k = 0;
            while (k < this.mEtatEnergies[i5].mIdTag.length) {
                ((EtatEnergie)this.mEtatEnergies[i5]).mIdTag[k] = Values.readUnsignedByte(byteBuffer);
                ++k;
            }
            this.mEtatEnergies[i5].mFctEnergie = Values.readUnsignedByte(byteBuffer);
            this.mEtatEnergies[i5].mRestant = byteBuffer.getInt();
            ++i5;
        }
        this.mForcageSInt = Values.readUnsignedShort(byteBuffer);
        this.mForcageSExt = Values.readUnsignedShort(byteBuffer);
        this.mForcageSVoy = Values.readUnsignedShort(byteBuffer);
        this.mForcageInitEnergie = Values.readUnsignedShort(byteBuffer);
        this.mTimestampDateHeure = Values.readUnsignedInt(byteBuffer);
        this.mTempVentilo = Values.readUnsignedShort(byteBuffer);
        this.mTempChauffage = Values.readUnsignedShort(byteBuffer);
        i5 = 0;
        while (i5 < this.getEchelles().length) {
            this.getEchelles()[i5] = byteBuffer.getFloat();
            ++i5;
        }
        i5 = 0;
        while (i5 < this.getPlugTypes().length) {
            this.getPlugTypes()[i5] = byteBuffer.get();
            ++i5;
        }
        this.mEnergieHS = Values.readUnsignedByte(byteBuffer);
    }

    public int getVersion() {
        return this.mVersion;
    }

    public void setVersion(int version) {
        this.mVersion = version;
    }

    public int getCarteId() {
        return this.mCarteId;
    }

    public void setCarteId(int carteId) {
        this.mCarteId = carteId;
    }

    public int getModeCarte() {
        return this.mModeCarte;
    }

    public void setModeCarte(int modeCarte) {
        this.mModeCarte = modeCarte;
    }

    public int getModeComptage() {
        return this.mModeComptage;
    }

    public void setModeComptage(int modeComptage) {
        this.mModeComptage = modeComptage;
    }

    public int getSlaveId() {
        return this.mSlaveId;
    }

    public void setSlaveId(int slaveId) {
        this.mSlaveId = slaveId;
    }

    public int getNumZone() {
        return this.mNumZone;
    }

    public void setNumZone(int numZone) {
        this.mNumZone = numZone;
    }

    public boolean isVoyantVert() {
        return this.mVoyantVert;
    }

    public void setVoyantVert(boolean voyantVert) {
        this.mVoyantVert = voyantVert;
    }

    public boolean isVoyantRouge() {
        return this.mVoyantRouge;
    }

    public void setVoyantRouge(boolean voyantRouge) {
        this.mVoyantRouge = voyantRouge;
    }

    public int getTemperature() {
        return this.mTemperature;
    }

    public void setTemperature(int temperature) {
        this.mTemperature = temperature;
    }

    public static String readString(ByteBuffer bb, int size) {
        byte[] buffer = new byte[size];
        bb.get(buffer);
        int length = 0;
        System.out.println("*************");
        byte[] byArray = buffer;
        int n = buffer.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            System.out.println(b);
            if (b == 0) break;
            ++length;
            ++n2;
        }
        String s = new String(buffer, 0, length);
        System.out.println(s);
        return s;
    }

    public static short readUnsignedByte(ByteBuffer bb) {
        return (short)(bb.get() & 0xFF);
    }

    public static int readUnsignedShort(ByteBuffer bb) {
        return bb.getShort() & 0xFFFF;
    }

    public static long readUnsignedInt(ByteBuffer bb) {
        return (long)bb.getInt() & 0xFFFFFFFFL;
    }

    public Prise getPrise(int i) {
        return this.mPrises[i];
    }

    public boolean getEntree(int i) {
        return this.mEntrees[i];
    }

    public boolean getSortie(int i) {
        return this.mSorties[i];
    }

    public int getIdLocalisation() {
        return this.idLocalisation;
    }

    public void setIdLocalisation(int idLocalisation) {
        this.idLocalisation = idLocalisation;
    }

    public Prise[] getPrises() {
        return this.mPrises;
    }

    public void setPrises(Prise[] prises) {
        this.mPrises = prises;
    }

    public boolean[] getEntrees() {
        return this.mEntrees;
    }

    public void setEntrees(boolean[] entrees) {
        this.mEntrees = entrees;
    }

    public boolean[] getSorties() {
        return this.mSorties;
    }

    public void setSorties(boolean[] sorties) {
        this.mSorties = sorties;
    }

    public EtatEnergie[] getEtatEnergies() {
        return this.mEtatEnergies;
    }

    public void setEtatEnergies(EtatEnergie[] etatEnergies) {
        this.mEtatEnergies = etatEnergies;
    }

    public int getForcageSInt() {
        return this.mForcageSInt;
    }

    public void setForcageSInt(int forcageSInt) {
        this.mForcageSInt = forcageSInt;
    }

    public int getForcageSExt() {
        return this.mForcageSExt;
    }

    public void setForcageSExt(int forcageSExt) {
        this.mForcageSExt = forcageSExt;
    }

    public int getForcageSVoy() {
        return this.mForcageSVoy;
    }

    public void setForcageSVoy(int forcageSVoy) {
        this.mForcageSVoy = forcageSVoy;
    }

    public int getForcageInitEnergie() {
        return this.mForcageInitEnergie;
    }

    public void setForcageInitEnergie(int forcageInitEnergie) {
        this.mForcageInitEnergie = forcageInitEnergie;
    }

    public long getTimestampDateHeure() {
        return this.mTimestampDateHeure;
    }

    public void setTimestampDateHeure(long timestampDateHeure) {
        this.mTimestampDateHeure = timestampDateHeure;
    }

    public int getTempVentilo() {
        return this.mTempVentilo;
    }

    public void setTempVentilo(int tempVentilo) {
        this.mTempVentilo = tempVentilo;
    }

    public int getTempChauffage() {
        return this.mTempChauffage;
    }

    public void setTempChauffage(int tempChauffage) {
        this.mTempChauffage = tempChauffage;
    }

    public float getEchelle(int i) {
        return this.getEchelles()[i];
    }

    public void setEchelle(int i, float echelle) {
        this.getEchelles()[i] = echelle;
    }

    public byte getPlugType(int i) {
        return this.getPlugTypes()[i];
    }

    public void setPlugType(int i, byte type) {
        this.getPlugTypes()[i] = type;
    }

    public short getEnergieHS() {
        return this.mEnergieHS;
    }

    public void setEnergieHS(short energieHS) {
        this.mEnergieHS = energieHS;
    }

    public float[] getEchelles() {
        return this.mEchelles;
    }

    public byte[] getPlugTypes() {
        return this.mPlugTypes;
    }

    public boolean isEnableWifi() {
        return this.mEnableWifi;
    }

    public String getSSIDWifi() {
        return this.mSSIDWifi;
    }

    public String getKeyWifi() {
        return this.mKeyWifi;
    }

    public boolean isDHCPWifi() {
        return this.mDHCPWifi;
    }

    public short[] getConfIpWifi() {
        return this.mConfIpWifi;
    }

    public short[] getConfSubnetWifi() {
        return this.mCongSubnetWifi;
    }

    public short[] getConfGatewayWifi() {
        return this.mConfGatewayWifi;
    }

    public short[] getNFCKey() {
        return this.mNFCKey;
    }

    public short[] getDestIp() {
        return this.mDestIp;
    }

    public int getDestPort() {
        return this.mDestPort;
    }

    public void setEnableWifi(boolean enableWifi) {
        this.mEnableWifi = enableWifi;
    }

    public void setSSIDWifi(String sSIDWifi) {
        this.mSSIDWifi = sSIDWifi;
    }

    public void setKeyWifi(String keyWifi) {
        this.mKeyWifi = keyWifi;
    }

    public void setDHCPWifi(boolean dHCPWifi) {
        this.mDHCPWifi = dHCPWifi;
    }

    public void setConfIpWifi(short[] confIpWifi) {
        this.mConfIpWifi = confIpWifi;
    }

    public void setConfSubnetWifi(short[] congSubnetWifi) {
        this.mCongSubnetWifi = congSubnetWifi;
    }

    public void setConfGatewayWifi(short[] confGatewayWifi) {
        this.mConfGatewayWifi = confGatewayWifi;
    }

    public void setNFCKey(short[] nfcKey) {
        this.mNFCKey = nfcKey;
    }

    public void setDestIp(short[] destIp) {
        this.mDestIp = destIp;
    }

    public void setDestPort(int destPort) {
        this.mDestPort = destPort;
    }

    private static class EtatEnergie {
        private short[] mIdTag = new short[8];
        private short mFctEnergie;
        private int mRestant;

        private EtatEnergie() {
        }
    }
}

