/*
 * Decompiled with CFR 0.152.
 */
package fr.iiprocess.marina.serial;

import fr.iiprocess.marina.model.Values;
import fr.iiprocess.marina.serial.IModbusListener;
import fr.iiprocess.marina.serial.ModbusHelper;
import java.util.ArrayList;
import java.util.List;

public class DaemonReader
implements Runnable {
    private static final DaemonReader mInstance = new DaemonReader();
    private boolean mRun = false;
    private final Thread mThread = new Thread((Runnable)this, "Modbus");
    private final List<IModbusListener> mListeners = new ArrayList<IModbusListener>();
    private STATUS mStatus = STATUS.DISCONNECTED;

    private DaemonReader() {
        this.mThread.setDaemon(true);
        this.mThread.start();
    }

    public static DaemonReader getInstance() {
        return mInstance;
    }

    public boolean isRunning() {
        return this.mRun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStatusChanged() {
        List<IModbusListener> list = this.mListeners;
        synchronized (list) {
            for (IModbusListener listener : this.mListeners) {
                listener.statusChanged(this.mStatus);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireReadedValues(Values values) {
        List<IModbusListener> list = this.mListeners;
        synchronized (list) {
            for (IModbusListener listener : this.mListeners) {
                listener.statusReadedValues(values);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IModbusListener listener) {
        List<IModbusListener> list = this.mListeners;
        synchronized (list) {
            this.mListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IModbusListener listener) {
        List<IModbusListener> list = this.mListeners;
        synchronized (list) {
            this.mListeners.remove(listener);
        }
    }

    public void start() {
        this.mRun = true;
    }

    public void stop() {
        this.mRun = false;
    }

    @Override
    public void run() {
        ModbusHelper modbusHelper = ModbusHelper.getInstance();
        while (true) {
            try {
                try {
                    if (this.mRun) {
                        Values values = new Values();
                        values.fillMetrics(modbusHelper.readMetrics());
                        this.fireReadedValues(values);
                        this.mStatus = STATUS.CONNECTED;
                        this.fireStatusChanged();
                        continue;
                    }
                    this.mStatus = STATUS.DISCONNECTED;
                    this.fireStatusChanged();
                }
                catch (Exception e) {
                    this.mStatus = STATUS.ERROR;
                    this.fireStatusChanged();
                    try {
                        Thread.sleep(150L);
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                }
                continue;
            }
            finally {
                try {
                    Thread.sleep(150L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            break;
        }
    }

    public static enum STATUS {
        DISCONNECTED,
        CONNECTED,
        ERROR;

    }
}

