/*
 * Decompiled with CFR 0.152.
 */
package fr.iiprocess.marina.serial;

import com.ghgande.j2mod.modbus.facade.ModbusSerialMaster;
import com.ghgande.j2mod.modbus.procimg.Register;
import com.ghgande.j2mod.modbus.procimg.SimpleRegister;
import com.ghgande.j2mod.modbus.util.SerialParameters;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ModbusHelper {
    private static final ModbusHelper mInstance = new ModbusHelper();
    private ModbusSerialMaster mMaster;
    private int mSlaveId = 1;
    private String mPortname = "/dev/ttyUSB0";

    private ModbusHelper() {
    }

    private void connect() throws Exception {
        this.disconnect();
        SerialParameters parameters = new SerialParameters(this.getPortname(), 19200, 0, 0, 8, 1, 0, false);
        parameters.setEncoding("rtu");
        this.mMaster = new ModbusSerialMaster(parameters);
        this.mMaster.connect();
    }

    public void disconnect() {
        if (this.mMaster != null) {
            this.mMaster.disconnect();
            this.mMaster = null;
        }
    }

    private synchronized void writeMultipleRegisters(int address, ByteBuffer byteBuffer) throws Exception {
        if (!this.isConnected()) {
            this.connect();
        }
        System.out.println("write address: " + address + " capacity: " + byteBuffer.capacity());
        byte[] bytes = byteBuffer.array();
        Register[] registers = new Register[bytes.length / 2];
        int i = 0;
        while (i < registers.length) {
            registers[i] = new SimpleRegister(bytes[i * 2], bytes[i * 2 + 1]);
            ++i;
        }
        this.mMaster.writeMultipleRegisters(this.getSlaveId(), address, registers);
    }

    public synchronized ByteBuffer readMultipleRegisters(int address, int length) throws Exception {
        if (!this.isConnected()) {
            this.connect();
        }
        System.out.println("read address: " + address + " length: " + length);
        Register[] registers = this.mMaster.readMultipleRegisters(this.getSlaveId(), address, length);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Register[] registerArray = registers;
        int n = registers.length;
        int n2 = 0;
        while (n2 < n) {
            Register register = registerArray[n2];
            byte[] bytes = register.toBytes();
            baos.write(bytes);
            ++n2;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(baos.toByteArray());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return byteBuffer;
    }

    public ByteBuffer read(int address, int length) throws Exception {
        this.connect();
        ByteBuffer buffer = this.readMultipleRegisters(address, length);
        this.disconnect();
        return buffer;
    }

    public int getSlaveId() {
        return this.mSlaveId;
    }

    public void setSlaveId(int slaveId) {
        this.mSlaveId = slaveId;
    }

    public String getPortname() {
        return this.mPortname;
    }

    public void setPortname(String portname) {
        this.mPortname = portname;
    }

    public static ModbusHelper getInstance() {
        return mInstance;
    }

    public boolean isConnected() {
        return this.mMaster != null;
    }

    public ByteBuffer readMetrics() throws Exception {
        return this.readMultipleRegisters(8192, 122);
    }

    public ByteBuffer readWifi() throws Exception {
        return this.readMultipleRegisters(8314, 48);
    }

    public void write(int address, ByteBuffer byteBuffer) throws Exception {
        this.writeMultipleRegisters(address, byteBuffer);
    }
}

