/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import gnu.io.CommDriver;
import gnu.io.CommPort;
import gnu.io.CommPortEnumerator;
import gnu.io.CommPortOwnershipListener;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.RXTXVersion;
import gnu.io.UnsupportedCommOperationException;
import java.io.FileDescriptor;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Logger;

public class CommPortIdentifier {
    private static final Logger LOGGER = Logger.getLogger(CommPortIdentifier.class.getName());
    public static final int PORT_SERIAL = 1;
    public static final int PORT_PARALLEL = 2;
    public static final int PORT_I2C = 3;
    public static final int PORT_RS485 = 4;
    public static final int PORT_RAW = 5;
    private final String portName;
    private boolean Available = true;
    private String Owner;
    private CommPort commPort;
    private CommDriver RXTXDriver;
    static CommPortIdentifier CommPortIndex;
    CommPortIdentifier next;
    private final int portType;
    static final Object Sync;
    Vector ownershipListener;
    private boolean HideOwnerEvents;

    static {
        Sync = new Object();
        try {
            CommDriver RXTXDriver = (CommDriver)Class.forName("gnu.io.RXTXCommDriver").newInstance();
            RXTXDriver.initialize();
        }
        catch (Throwable e) {
            System.err.println(e + " thrown while loading " + "gnu.io.RXTXCommDriver");
        }
        String OS = System.getProperty("os.name");
        if (OS.toLowerCase().indexOf("linux") == -1) {
            LOGGER.warning("Have not implemented native_psmisc_report_owner(PortName)); in CommPortIdentifier");
        }
        RXTXVersion.ensureNativeCodeLoaded();
    }

    CommPortIdentifier(String portName, CommPort commPort, int portType, CommDriver driver) {
        this.portName = portName;
        this.commPort = commPort;
        this.portType = portType;
        this.next = null;
        this.RXTXDriver = driver;
    }

    public static void addPortName(String s, int type, CommDriver c) {
        LOGGER.fine("CommPortIdentifier:addPortName(" + s + ")");
        CommPortIdentifier.AddIdentifierToList(new CommPortIdentifier(s, null, type, c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void AddIdentifierToList(CommPortIdentifier cpi) {
        LOGGER.fine("CommPortIdentifier:AddIdentifierToList()");
        Object object = Sync;
        synchronized (object) {
            if (CommPortIndex == null) {
                CommPortIndex = cpi;
                LOGGER.fine("CommPortIdentifier:AddIdentifierToList() null");
            } else {
                CommPortIdentifier index = CommPortIndex;
                while (index.next != null) {
                    index = index.next;
                    LOGGER.fine("CommPortIdentifier:AddIdentifierToList() index.next");
                }
                index.next = cpi;
            }
        }
    }

    public void addPortOwnershipListener(CommPortOwnershipListener c) {
        LOGGER.fine("CommPortIdentifier:addPortOwnershipListener()");
        if (this.ownershipListener == null) {
            this.ownershipListener = new Vector();
        }
        if (!this.ownershipListener.contains(c)) {
            this.ownershipListener.addElement(c);
        }
    }

    public String getCurrentOwner() {
        return this.Owner;
    }

    public String getName() {
        return this.portName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommPortIdentifier getPortIdentifier(String s) throws NoSuchPortException {
        CommPortIdentifier index;
        LOGGER.fine("CommPortIdentifier:getPortIdentifier(" + s + ")");
        Object object = Sync;
        synchronized (object) {
            index = CommPortIndex;
            while (index != null && !index.portName.equals(s)) {
                index = index.next;
            }
            if (index == null) {
                CommPortIdentifier.getPortIdentifiers();
                index = CommPortIndex;
                while (index != null && !index.portName.equals(s)) {
                    index = index.next;
                }
            }
        }
        if (index != null) {
            return index;
        }
        LOGGER.fine("not found!" + s);
        throw new NoSuchPortException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommPortIdentifier getPortIdentifier(CommPort p) throws NoSuchPortException {
        CommPortIdentifier c;
        LOGGER.fine("CommPortIdentifier:getPortIdentifier(CommPort)");
        Object object = Sync;
        synchronized (object) {
            c = CommPortIndex;
            while (c != null && c.commPort != p) {
                c = c.next;
            }
        }
        if (c != null) {
            return c;
        }
        LOGGER.fine("not found!" + p.getName());
        throw new NoSuchPortException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enumeration<CommPortIdentifier> getPortIdentifiers() {
        LOGGER.fine("static CommPortIdentifier:getPortIdentifiers()");
        Object object = Sync;
        synchronized (object) {
            HashMap<String, CommPortIdentifier> oldPorts = new HashMap<String, CommPortIdentifier>();
            CommPortIdentifier p = CommPortIndex;
            while (p != null) {
                oldPorts.put(p.portName, p);
                p = p.next;
            }
            CommPortIndex = null;
            try {
                CommDriver RXTXDriver = (CommDriver)Class.forName("gnu.io.RXTXCommDriver").newInstance();
                RXTXDriver.initialize();
                CommPortIdentifier curPort = CommPortIndex;
                CommPortIdentifier prevPort = null;
                while (curPort != null) {
                    CommPortIdentifier matchingOldPort = (CommPortIdentifier)oldPorts.get(curPort.portName);
                    if (matchingOldPort != null && matchingOldPort.portType == curPort.portType) {
                        matchingOldPort.RXTXDriver = curPort.RXTXDriver;
                        matchingOldPort.next = curPort.next;
                        if (prevPort == null) {
                            CommPortIndex = matchingOldPort;
                        } else {
                            prevPort.next = matchingOldPort;
                        }
                        prevPort = matchingOldPort;
                    } else {
                        prevPort = curPort;
                    }
                    curPort = curPort.next;
                }
            }
            catch (Throwable e) {
                System.err.println(e + " thrown while loading " + "gnu.io.RXTXCommDriver");
                System.err.flush();
            }
        }
        return new CommPortEnumerator();
    }

    public int getPortType() {
        return this.portType;
    }

    public synchronized boolean isCurrentlyOwned() {
        return !this.Available;
    }

    public synchronized CommPort open(FileDescriptor f) throws UnsupportedCommOperationException {
        LOGGER.fine("CommPortIdentifier:open(FileDescriptor)");
        throw new UnsupportedCommOperationException();
    }

    private native String native_psmisc_report_owner(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommPort open(String TheOwner, int i) throws PortInUseException {
        String err_msg;
        block26: {
            CommPort commPort;
            block27: {
                CommPortIdentifier commPortIdentifier;
                boolean isAvailable;
                LOGGER.fine("CommPortIdentifier:open(" + TheOwner + ", " + i + ")");
                CommPortIdentifier commPortIdentifier2 = this;
                synchronized (commPortIdentifier2) {
                    isAvailable = this.Available;
                    if (isAvailable) {
                        this.Available = false;
                        this.Owner = TheOwner;
                    }
                }
                if (!isAvailable) {
                    long waitTimeEnd = System.currentTimeMillis() + (long)i;
                    this.fireOwnershipEvent(3);
                    commPortIdentifier = this;
                    synchronized (commPortIdentifier) {
                        long waitTimeCurr;
                        while (!this.Available && (waitTimeCurr = System.currentTimeMillis()) < waitTimeEnd) {
                            try {
                                this.wait(waitTimeEnd - waitTimeCurr);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                break;
                            }
                        }
                        isAvailable = this.Available;
                        if (isAvailable) {
                            this.Available = false;
                            this.Owner = TheOwner;
                        }
                    }
                }
                if (!isAvailable) {
                    throw new PortInUseException(this.getCurrentOwner());
                }
                try {
                    if (this.commPort == null) {
                        this.commPort = this.RXTXDriver.getCommPort(this.portName, this.portType);
                    }
                    if (this.commPort == null) break block26;
                    this.fireOwnershipEvent(1);
                    commPort = this.commPort;
                    if (this.commPort != null) break block27;
                    commPortIdentifier = this;
                }
                catch (Throwable throwable) {
                    if (this.commPort == null) {
                        commPortIdentifier = this;
                        synchronized (commPortIdentifier) {
                            this.Available = true;
                            this.Owner = null;
                        }
                    }
                    throw throwable;
                }
                synchronized (commPortIdentifier) {
                    this.Available = true;
                    this.Owner = null;
                }
            }
            return commPort;
        }
        try {
            err_msg = this.native_psmisc_report_owner(this.portName);
        }
        catch (Throwable t) {
            err_msg = "Port " + this.portName + " already owned... unable to open.";
        }
        throw new PortInUseException(err_msg);
    }

    public void removePortOwnershipListener(CommPortOwnershipListener c) {
        LOGGER.fine("CommPortIdentifier:removePortOwnershipListener()");
        if (this.ownershipListener != null) {
            this.ownershipListener.removeElement(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalClosePort() {
        CommPortIdentifier commPortIdentifier = this;
        synchronized (commPortIdentifier) {
            LOGGER.fine("CommPortIdentifier:internalClosePort()");
            this.Owner = null;
            this.Available = true;
            this.commPort = null;
            this.notifyAll();
        }
        this.fireOwnershipEvent(2);
    }

    void fireOwnershipEvent(int eventType) {
        LOGGER.fine("CommPortIdentifier:fireOwnershipEvent( " + eventType + " )");
        if (this.ownershipListener != null) {
            Enumeration e = this.ownershipListener.elements();
            while (e.hasMoreElements()) {
                CommPortOwnershipListener c = (CommPortOwnershipListener)e.nextElement();
                c.ownershipChange(eventType);
            }
        }
    }
}

