/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import gnu.io.CommDriver;
import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.RXTXPort;
import gnu.io.RXTXVersion;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class RXTXCommDriver
implements CommDriver {
    private static final Logger logger = Logger.getLogger(RXTXCommDriver.class.getName());
    private String deviceDirectory;

    static {
        RXTXVersion.ensureNativeCodeLoaded();
    }

    private native boolean registerKnownPorts(int var1);

    private native boolean isPortPrefixValid(String var1);

    private native boolean testRead(String var1, int var2);

    private native String getDeviceDirectory();

    private final String[] getValidPortPrefixes(String[] CandidatePortPrefixes) {
        String[] ValidPortPrefixes = new String[256];
        logger.fine("\nRXTXCommDriver:getValidPortPrefixes()");
        if (CandidatePortPrefixes == null) {
            logger.fine("\nRXTXCommDriver:getValidPortPrefixes() No ports prefixes known for this System.\nPlease check the port prefixes listed for " + RXTXVersion.getOsName() + " in RXTXCommDriver:registerScannedPorts()\n");
        }
        int i = 0;
        int j = 0;
        while (j < CandidatePortPrefixes.length) {
            if (this.isPortPrefixValid(CandidatePortPrefixes[j])) {
                ValidPortPrefixes[i++] = CandidatePortPrefixes[j];
            }
            ++j;
        }
        String[] returnArray = new String[i];
        System.arraycopy(ValidPortPrefixes, 0, returnArray, 0, i);
        if (ValidPortPrefixes[0] == null) {
            logger.fine("\nRXTXCommDriver:getValidPortPrefixes() No ports matched the list assumed for this\nSystem in the directory " + this.deviceDirectory + ".  Please check the ports listed for \"" + RXTXVersion.getOsName() + "\" in\nRXTXCommDriver:registerScannedPorts()\nTried:");
            int j2 = 0;
            while (j2 < CandidatePortPrefixes.length) {
                logger.fine("\t" + CandidatePortPrefixes[i]);
                ++j2;
            }
        } else {
            logger.fine("\nRXTXCommDriver:getValidPortPrefixes()\nThe following port prefixes have been identified as valid on " + RXTXVersion.getOsName() + ":\n");
        }
        return returnArray;
    }

    private void checkSolaris(String PortName, int PortType) {
        char[] p = new char[]{'['};
        p[0] = 97;
        while (p[0] < '{') {
            if (this.testRead(PortName.concat(new String(p)), PortType)) {
                CommPortIdentifier.addPortName(PortName.concat(new String(p)), PortType, this);
            }
            p[0] = (char)(p[0] + '\u0001');
        }
        p[0] = 48;
        while (p[0] <= '9') {
            if (this.testRead(PortName.concat(new String(p)), PortType)) {
                CommPortIdentifier.addPortName(PortName.concat(new String(p)), PortType, this);
            }
            p[0] = (char)(p[0] + '\u0001');
        }
    }

    private void registerValidPorts(String[] CandidateDeviceNames, String[] ValidPortPrefixes, int PortType) {
        int i = 0;
        int p = 0;
        logger.fine("Entering registerValidPorts()");
        logger.fine(" Candidate devices:");
        int dn = 0;
        while (dn < CandidateDeviceNames.length) {
            logger.fine("  " + CandidateDeviceNames[dn]);
            ++dn;
        }
        logger.fine(" valid port prefixes:");
        int pp = 0;
        while (pp < ValidPortPrefixes.length) {
            logger.fine("  " + ValidPortPrefixes[pp]);
            ++pp;
        }
        if (CandidateDeviceNames != null && ValidPortPrefixes != null) {
            i = 0;
            while (i < CandidateDeviceNames.length) {
                p = 0;
                while (p < ValidPortPrefixes.length) {
                    String V = ValidPortPrefixes[p];
                    int VL = V.length();
                    String C = CandidateDeviceNames[i];
                    if (C.length() >= VL) {
                        String CU = C.substring(VL).toUpperCase();
                        String Cl = C.substring(VL).toLowerCase();
                        if (C.regionMatches(0, V, 0, VL) && CU.equals(Cl)) {
                            String PortName = RXTXVersion.getOsName().toLowerCase().indexOf("windows") == -1 ? String.valueOf(this.deviceDirectory) + C : C;
                            logger.fine(String.valueOf(C) + " " + V);
                            logger.fine(String.valueOf(CU) + " " + Cl);
                            if (RXTXVersion.getOsName().equals("Solaris") || RXTXVersion.getOsName().equals("SunOS")) {
                                this.checkSolaris(PortName, PortType);
                            } else if (this.testRead(PortName, PortType)) {
                                CommPortIdentifier.addPortName(PortName, PortType, this);
                            }
                        }
                    }
                    ++p;
                }
                ++i;
            }
        }
        logger.fine("Leaving registerValidPorts()");
    }

    @Override
    public void initialize() {
        this.deviceDirectory = this.getDeviceDirectory();
        int PortType = 1;
        while (PortType <= 2) {
            if (!this.registerSpecifiedPorts(PortType) && !this.registerKnownPorts(PortType)) {
                this.registerScannedPorts(PortType);
            }
            ++PortType;
        }
    }

    private void addSpecifiedPorts(String names, int PortType) {
        String pathSep = System.getProperty("path.separator", ":");
        StringTokenizer tok = new StringTokenizer(names, pathSep);
        logger.fine("\nRXTXCommDriver:addSpecifiedPorts()");
        while (tok.hasMoreElements()) {
            String PortName = tok.nextToken();
            if (!this.testRead(PortName, PortType)) continue;
            CommPortIdentifier.addPortName(PortName, PortType, this);
        }
    }

    private boolean registerSpecifiedPorts(int PortType) {
        String val;
        block30: {
            block29: {
                Properties props;
                block28: {
                    val = null;
                    props = null;
                    String file_loc = null;
                    String ext_dirs = System.getProperty("java.ext.dirs");
                    String[] dirArray = ext_dirs.split(System.getProperty("path.separator"));
                    int i = 0;
                    while (i < dirArray.length) {
                        String file_name = String.valueOf(dirArray[i]) + System.getProperty("file.separator") + "gnu.io.rxtx.properties";
                        File file = new File(file_name);
                        if (file.exists()) {
                            file_loc = file_name;
                            break;
                        }
                        ++i;
                    }
                    if (file_loc != null) {
                        FileInputStream in = null;
                        try {
                            try {
                                in = new FileInputStream(file_loc);
                                props = new Properties();
                                props.load(in);
                            }
                            catch (Exception e) {
                                logger.fine("Error encountered while reading " + file_loc + ": " + e);
                                if (in != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                break block28;
                            }
                        }
                        catch (Throwable file) {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            throw file;
                        }
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (props == null) {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    try {
                        Enumeration<URL> resources = loader.getResources("gnu.io.rxtx.properties");
                        if (resources.hasMoreElements()) {
                            URL propertyURL = resources.nextElement();
                            props = new Properties();
                            props.load(propertyURL.openStream());
                        }
                    }
                    catch (IOException e) {
                        logger.fine("Error encountered while getting gnu.io.rxtx.properties from the classpath: " + e);
                    }
                }
                logger.fine("checking for system-known ports of type " + PortType);
                logger.fine("checking registry for ports of type " + PortType);
                if (props == null) break block29;
                switch (PortType) {
                    case 1: {
                        val = props.getProperty("gnu.io.rxtx.SerialPorts");
                        if (val == null) {
                            val = props.getProperty("gnu.io.SerialPorts");
                            break;
                        }
                        break block30;
                    }
                    case 2: {
                        val = props.getProperty("gnu.io.rxtx.ParallelPorts");
                        if (val == null) {
                            val = props.getProperty("gnu.io.ParallelPorts");
                            break;
                        }
                        break block30;
                    }
                    default: {
                        logger.fine("unknown port type " + PortType + " passed to RXTXCommDriver.registerSpecifiedPorts()");
                        break;
                    }
                }
                break block30;
            }
            logger.fine("The file: gnu.io.rxtx.properties doesn't exist.");
        }
        if (val != null) {
            this.addSpecifiedPorts(val, PortType);
            return true;
        }
        return false;
    }

    private void registerScannedPorts(int PortType) {
        String[] CandidateDeviceNames;
        String[] temp;
        logger.fine("scanning device directory " + this.deviceDirectory + " for ports of type " + PortType);
        if (RXTXVersion.getOsName().equals("Windows CE")) {
            CandidateDeviceNames = temp = new String[]{"COM1:", "COM2:", "COM3:", "COM4:", "COM5:", "COM6:", "COM7:", "COM8:"};
        } else if (RXTXVersion.getOsName().toLowerCase().indexOf("windows") != -1) {
            temp = new String[259];
            int i = 1;
            while (i <= 256) {
                temp[i - 1] = "COM" + i;
                ++i;
            }
            i = 1;
            while (i <= 3) {
                temp[i + 255] = "LPT" + i;
                ++i;
            }
            CandidateDeviceNames = temp;
        } else if (RXTXVersion.getOsName().equals("Solaris") || RXTXVersion.getOsName().equals("SunOS")) {
            String[] term = new String[2];
            int l = 0;
            File dev = null;
            dev = new File("/dev/term");
            if (dev.list().length > 0) {
                term[l++] = "term/";
            }
            String[] temp2 = new String[l];
            --l;
            while (l >= 0) {
                temp2[l] = term[l];
                --l;
            }
            CandidateDeviceNames = temp2;
        } else {
            File dev = new File(this.deviceDirectory);
            String[] temp3 = dev.list();
            CandidateDeviceNames = temp3;
        }
        if (CandidateDeviceNames == null) {
            logger.fine("RXTXCommDriver:registerScannedPorts() no Device files to check ");
            return;
        }
        String[] CandidatePortPrefixes = new String[]{};
        switch (PortType) {
            case 1: {
                logger.fine("scanning for serial ports for os " + RXTXVersion.getOsName());
                if (RXTXVersion.getOsName().equals("Linux")) {
                    String[] Temp = new String[]{"ttyS", "ttyAMA", "ttySA", "ttyUSB", "rfcomm", "ttyircomm"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (RXTXVersion.getOsName().equals("Linux-all-ports")) {
                    String[] Temp = new String[]{"comx", "holter", "modem", "rfcomm", "ttyircomm", "ttycosa0c", "ttycosa1c", "ttyACM", "ttyC", "ttyCH", "ttyD", "ttyE", "ttyF", "ttyH", "ttyI", "ttyL", "ttyM", "ttyMX", "ttyP", "ttyR", "ttyS", "ttySI", "ttySR", "ttyT", "ttyUSB", "ttyV", "ttyW", "ttyX"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (RXTXVersion.getOsName().toLowerCase().indexOf("qnx") != -1) {
                    String[] Temp = new String[]{"ser"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (RXTXVersion.getOsName().equals("Irix")) {
                    String[] Temp = new String[]{"ttyc", "ttyd", "ttyf", "ttym", "ttyq", "tty4d", "tty4f", "midi", "us"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (RXTXVersion.getOsName().equals("FreeBSD")) {
                    String[] Temp = new String[]{"ttyd", "cuaa", "ttyA", "cuaA", "ttyD", "cuaD", "ttyE", "cuaE", "ttyF", "cuaF", "ttyR", "cuaR", "stl"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (RXTXVersion.getOsName().equals("NetBSD")) {
                    String[] Temp = new String[]{"tty0"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (RXTXVersion.getOsName().equals("Solaris") || RXTXVersion.getOsName().equals("SunOS")) {
                    String[] Temp = new String[]{"term/", "cua/"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (RXTXVersion.getOsName().equals("HP-UX")) {
                    String[] Temp = new String[]{"tty0p", "tty1p"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (RXTXVersion.getOsName().equals("UnixWare") || RXTXVersion.getOsName().equals("OpenUNIX")) {
                    String[] Temp = new String[]{"tty00s", "tty01s", "tty02s", "tty03s"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (RXTXVersion.getOsName().equals("OpenServer")) {
                    String[] Temp = new String[]{"tty1A", "tty2A", "tty3A", "tty4A", "tty5A", "tty6A", "tty7A", "tty8A", "tty9A", "tty10A", "tty11A", "tty12A", "tty13A", "tty14A", "tty15A", "tty16A", "ttyu1A", "ttyu2A", "ttyu3A", "ttyu4A", "ttyu5A", "ttyu6A", "ttyu7A", "ttyu8A", "ttyu9A", "ttyu10A", "ttyu11A", "ttyu12A", "ttyu13A", "ttyu14A", "ttyu15A", "ttyu16A"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (RXTXVersion.getOsName().equals("Compaq's Digital UNIX") || RXTXVersion.getOsName().equals("OSF1")) {
                    String[] Temp = new String[]{"tty0"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (RXTXVersion.getOsName().equals("BeOS")) {
                    String[] Temp = new String[]{"serial"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (RXTXVersion.getOsName().equals("Mac OS X")) {
                    String[] Temp = new String[]{"cu.KeyUSA28X191.", "tty.KeyUSA28X191.", "cu.KeyUSA28X181.", "tty.KeyUSA28X181.", "cu.KeyUSA19181.", "tty.KeyUSA19181."};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (RXTXVersion.getOsName().toLowerCase().indexOf("windows") != -1) {
                    String[] Temp = new String[]{"COM"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                logger.fine("No valid prefixes for serial ports have been entered for " + RXTXVersion.getOsName() + " in RXTXCommDriver.java.  This may just be a typo in the method registerScanPorts().");
                break;
            }
            case 2: {
                logger.fine("scanning for parallel ports for os " + RXTXVersion.getOsName());
                if (RXTXVersion.getOsName().equals("Linux")) {
                    String[] temp4 = new String[]{"lp"};
                    CandidatePortPrefixes = temp4;
                    break;
                }
                if (RXTXVersion.getOsName().equals("FreeBSD")) {
                    String[] temp5 = new String[]{"lpt"};
                    CandidatePortPrefixes = temp5;
                    break;
                }
                if (RXTXVersion.getOsName().toLowerCase().indexOf("windows") != -1) {
                    String[] temp6 = new String[]{"LPT"};
                    CandidatePortPrefixes = temp6;
                    break;
                }
                String[] temp7 = new String[]{};
                CandidatePortPrefixes = temp7;
                break;
            }
            default: {
                logger.fine("Unknown PortType " + PortType + " passed to RXTXCommDriver.registerScannedPorts()");
            }
        }
        this.registerValidPorts(CandidateDeviceNames, CandidatePortPrefixes, PortType);
    }

    @Override
    public CommPort getCommPort(String PortName, int PortType) {
        logger.fine("RXTXCommDriver:getCommPort(" + PortName + "," + PortType + ")");
        try {
            switch (PortType) {
                case 1: {
                    if (RXTXVersion.getOsName().toLowerCase().indexOf("windows") == -1) {
                        return new RXTXPort(PortName);
                    }
                    return new RXTXPort(String.valueOf(this.deviceDirectory) + PortName);
                }
            }
            logger.fine("unknown PortType  " + PortType + " passed to RXTXCommDriver.getCommPort()");
        }
        catch (PortInUseException e) {
            logger.fine("Port " + PortName + " in use by another application");
        }
        return null;
    }

    public void Report(String arg) {
        System.out.println(arg);
    }
}

