/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import gnu.io.RXTXVersion;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RXTXInitializer {
    private static final Logger LOGGER = Logger.getLogger(RXTXInitializer.class.getName());
    private static final String RESOURCE_NAME;
    private static final String JAR_VERSION;
    private static final String LIB_VERSION;
    private static final String BASE_NAME = "rxtxSerial";
    private static final String OSNAME;
    private static final String OSARCH;

    static {
        JAR_VERSION = RXTXVersion.getExpectedNativeVersion();
        OSNAME = System.getProperty("os.name");
        OSARCH = System.getProperty("os.arch");
        try {
            RESOURCE_NAME = RXTXInitializer.resourceName();
            RXTXInitializer.provideNativeLibraries();
            LIB_VERSION = RXTXVersion.nativeGetVersion();
            LOGGER.log(Level.INFO, "Native lib Version = {0}", LIB_VERSION);
            LOGGER.log(Level.INFO, "Java lib Version   = {0}", JAR_VERSION);
            if (!JAR_VERSION.equals(LIB_VERSION)) {
                LOGGER.warning("RXTX Version mismatch");
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot initialize native stuff", e);
        }
    }

    private static String resourceName() {
        String retVal = BASE_NAME;
        retVal = String.valueOf(retVal) + "-";
        retVal = String.valueOf(retVal) + OSARCH;
        retVal = OSNAME.toLowerCase().contains("windows") ? String.valueOf(retVal) + ".dll" : String.valueOf(retVal) + ".so";
        return retVal;
    }

    private static long copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[1024];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    /*
     * Unable to fully structure code
     */
    private static void provideNativeLibraries() throws IOException {
        outFile = new File(System.getProperty("java.io.tmpdir"));
        prefix = RXTXInitializer.RESOURCE_NAME.substring(0, RXTXInitializer.RESOURCE_NAME.lastIndexOf("."));
        suffix = RXTXInitializer.RESOURCE_NAME.substring(RXTXInitializer.RESOURCE_NAME.lastIndexOf(".") + 1, RXTXInitializer.RESOURCE_NAME.length());
        if ((outFile = new File(outFile, String.valueOf(prefix) + "-" + RXTXVersion.getVersion() + "." + suffix)).exists()) {
            outFile.delete();
        }
        if (!outFile.exists()) {
            var3_3 = null;
            var4_5 = null;
            try {
                is = RXTXVersion.class.getResourceAsStream(RXTXInitializer.RESOURCE_NAME);
                try {
                    fos = new FileOutputStream(outFile);
                    try {
                        RXTXInitializer.copy(is, fos);
                        RXTXInitializer.LOGGER.log(Level.INFO, "Copied {0} to {1}", new String[]{RXTXInitializer.RESOURCE_NAME, outFile.toString()});
                    }
                    finally {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    if (is == null) ** GOTO lbl44
                }
                catch (Throwable var4_6) {
                    if (var3_3 == null) {
                        var3_3 = var4_6;
                    } else if (var3_3 != var4_6) {
                        var3_3.addSuppressed(var4_6);
                    }
                    if (is != null) {
                        is.close();
                    }
                    throw var3_3;
                }
                is.close();
            }
            catch (Throwable var4_7) {
                if (var3_3 == null) {
                    var3_3 = var4_7;
                } else if (var3_3 != var4_7) {
                    var3_3.addSuppressed(var4_7);
                }
                throw var3_3;
            }
        } else {
            RXTXInitializer.LOGGER.log(Level.INFO, "Native library {0} already exists at {1}", new String[]{RXTXInitializer.RESOURCE_NAME, outFile.toString()});
        }
lbl44:
        // 3 sources

        System.load(outFile.getAbsolutePath());
        outFile.deleteOnExit();
    }
}

