/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import gnu.io.PortInUseException;
import gnu.io.RXTXVersion;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;
import java.util.logging.Logger;

public final class RXTXPort
extends SerialPort {
    private static final Logger logger = Logger.getAnonymousLogger();
    boolean MonitorThreadAlive = false;
    int IOLocked = 0;
    Object IOLockedMutex = new Object();
    private int fd = 0;
    long eis = 0L;
    int pid = 0;
    static boolean dsrFlag;
    private final SerialOutputStream out = new SerialOutputStream();
    private final SerialInputStream in = new SerialInputStream();
    private int speed = 9600;
    private int dataBits = 8;
    private int stopBits = 1;
    private int parity = 0;
    private int flowmode = 0;
    private int timeout;
    private int threshold = 0;
    private int InputBuffer = 0;
    private int OutputBuffer = 0;
    private SerialPortEventListener SPEventListener;
    private MonitorThread monThread;
    boolean monThreadisInterrupted = true;
    boolean MonitorThreadLock = true;
    boolean closeLock = false;

    static {
        RXTXVersion.ensureNativeCodeLoaded();
        RXTXPort.Initialize();
        dsrFlag = false;
    }

    private static native void Initialize();

    public RXTXPort(String name) throws PortInUseException {
        super(name);
        logger.fine("RXTXPort:RXTXPort(" + name + ") called");
        this.fd = this.open(name);
        this.MonitorThreadLock = true;
        this.monThread = new MonitorThread();
        this.monThread.setDaemon(true);
        this.monThread.start();
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadAlive = true;
        this.timeout = -1;
        logger.fine("RXTXPort:RXTXPort(" + name + ") returns with fd = " + this.fd);
    }

    private synchronized native int open(String var1) throws PortInUseException;

    @Override
    public OutputStream getOutputStream() {
        logger.fine("RXTXPort:getOutputStream() called and returning");
        return this.out;
    }

    @Override
    public InputStream getInputStream() {
        logger.fine("RXTXPort:getInputStream() called and returning");
        return this.in;
    }

    private native int nativeGetParity(int var1);

    private native int nativeGetFlowControlMode(int var1);

    @Override
    public synchronized void setSerialPortParams(int b, int d, int s, int p) throws UnsupportedCommOperationException {
        logger.fine("RXTXPort:setSerialPortParams(" + b + " " + d + " " + s + " " + p + ") called");
        if (this.nativeSetSerialPortParams(b, d, s, p)) {
            throw new UnsupportedCommOperationException("Invalid Parameter");
        }
        this.speed = b;
        this.dataBits = s == 3 ? 5 : d;
        this.stopBits = s;
        this.parity = p;
        logger.fine("RXTXPort:setSerialPortParams(" + b + " " + d + " " + s + " " + p + ") returning");
    }

    private native boolean nativeSetSerialPortParams(int var1, int var2, int var3, int var4) throws UnsupportedCommOperationException;

    @Override
    public int getBaudRate() {
        return this.speed;
    }

    @Override
    public int getDataBits() {
        return this.dataBits;
    }

    @Override
    public int getStopBits() {
        return this.stopBits;
    }

    @Override
    public int getParity() {
        return this.parity;
    }

    @Override
    public void setFlowControlMode(int flowcontrol) {
        logger.fine("RXTXPort:setFlowControlMode( " + flowcontrol + " ) called");
        if (this.monThreadisInterrupted) {
            logger.fine("RXTXPort:setFlowControlMode MonThread is Interrupeted returning");
            return;
        }
        try {
            this.setflowcontrol(flowcontrol);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.flowmode = flowcontrol;
        logger.fine("RXTXPort:setFlowControlMode( " + flowcontrol + " ) returning");
    }

    @Override
    public int getFlowControlMode() {
        return this.flowmode;
    }

    native void setflowcontrol(int var1) throws IOException;

    @Override
    public void enableReceiveFraming(int f) throws UnsupportedCommOperationException {
        throw new UnsupportedCommOperationException("Not supported");
    }

    @Override
    public void disableReceiveFraming() {
        logger.fine("RXTXPort:disableReceiveFramming() called and returning (noop)");
    }

    @Override
    public boolean isReceiveFramingEnabled() {
        logger.fine("RXTXPort:isReceiveFrammingEnabled() called and returning false");
        return false;
    }

    @Override
    public int getReceiveFramingByte() {
        return 0;
    }

    public native int NativegetReceiveTimeout();

    private native boolean NativeisReceiveTimeoutEnabled();

    private native void NativeEnableReceiveTimeoutThreshold(int var1, int var2, int var3);

    @Override
    public void disableReceiveTimeout() {
        logger.fine("RXTXPort:disableReceiveTimeout() called");
        this.timeout = -1;
        this.NativeEnableReceiveTimeoutThreshold(this.timeout, this.threshold, this.InputBuffer);
        logger.fine("RXTXPort:disableReceiveTimeout() returning");
    }

    @Override
    public void enableReceiveTimeout(int time) {
        logger.fine("RXTXPort:enableReceiveTimeout() called");
        if (time < 0) {
            throw new IllegalArgumentException("Unexpected negative timeout value");
        }
        this.timeout = time;
        this.NativeEnableReceiveTimeoutThreshold(time, this.threshold, this.InputBuffer);
        logger.fine("RXTXPort:enableReceiveTimeout() returning");
    }

    @Override
    public boolean isReceiveTimeoutEnabled() {
        logger.fine("RXTXPort:isReceiveTimeoutEnabled() called and returning " + this.NativeisReceiveTimeoutEnabled());
        return this.NativeisReceiveTimeoutEnabled();
    }

    @Override
    public int getReceiveTimeout() {
        logger.fine("RXTXPort:getReceiveTimeout() called and returning " + this.NativegetReceiveTimeout());
        return this.NativegetReceiveTimeout();
    }

    @Override
    public void enableReceiveThreshold(int thresh) {
        logger.fine("RXTXPort:enableReceiveThreshold( " + thresh + " ) called");
        if (thresh < 0) {
            throw new IllegalArgumentException("Unexpected negative threshold value");
        }
        this.threshold = thresh;
        this.NativeEnableReceiveTimeoutThreshold(this.timeout, this.threshold, this.InputBuffer);
        logger.fine("RXTXPort:enableReceiveThreshold( " + thresh + " ) returned");
    }

    @Override
    public void disableReceiveThreshold() {
        logger.fine("RXTXPort:disableReceiveThreshold() called and returning");
        this.enableReceiveThreshold(0);
    }

    @Override
    public int getReceiveThreshold() {
        logger.fine("RXTXPort:getReceiveThreshold() called and returning " + this.threshold);
        return this.threshold;
    }

    @Override
    public boolean isReceiveThresholdEnabled() {
        logger.fine("RXTXPort:isReceiveThresholdEnable() called and returning" + (this.threshold > 0));
        return this.threshold > 0;
    }

    @Override
    public void setInputBufferSize(int size) {
        logger.fine("RXTXPort:setInputBufferSize( " + size + ") called");
        if (size < 0) {
            throw new IllegalArgumentException("Unexpected negative buffer size value");
        }
        this.InputBuffer = size;
        logger.fine("RXTXPort:setInputBufferSize( " + size + ") returning");
    }

    @Override
    public int getInputBufferSize() {
        logger.fine("RXTXPort:getInputBufferSize() called and returning " + this.InputBuffer);
        return this.InputBuffer;
    }

    @Override
    public void setOutputBufferSize(int size) {
        logger.fine("RXTXPort:setOutputBufferSize( " + size + ") called");
        if (size < 0) {
            throw new IllegalArgumentException("Unexpected negative buffer size value");
        }
        this.OutputBuffer = size;
        logger.fine("RXTXPort:setOutputBufferSize( " + size + ") returned");
    }

    @Override
    public int getOutputBufferSize() {
        logger.fine("RXTXPort:getOutputBufferSize() called and returning " + this.OutputBuffer);
        return this.OutputBuffer;
    }

    @Override
    public native boolean isDTR();

    @Override
    public native void setDTR(boolean var1);

    @Override
    public native void setRTS(boolean var1);

    private native void setDSR(boolean var1);

    @Override
    public native boolean isCTS();

    @Override
    public native boolean isDSR();

    @Override
    public native boolean isCD();

    @Override
    public native boolean isRI();

    @Override
    public native boolean isRTS();

    @Override
    public native void sendBreak(int var1);

    protected native void writeByte(int var1, boolean var2) throws IOException;

    protected native void writeArray(byte[] var1, int var2, int var3, boolean var4) throws IOException;

    protected native boolean nativeDrain(boolean var1) throws IOException;

    protected native int nativeavailable() throws IOException;

    protected native int readByte() throws IOException;

    protected native int readArray(byte[] var1, int var2, int var3) throws IOException;

    protected native int readTerminatedArray(byte[] var1, int var2, int var3, byte[] var4) throws IOException;

    native void eventLoop();

    private native void interruptEventLoop();

    public boolean checkMonitorThread() {
        logger.fine("RXTXPort:checkMonitorThread()");
        if (this.monThread != null) {
            logger.fine("monThreadisInterrupted = " + this.monThreadisInterrupted);
            return this.monThreadisInterrupted;
        }
        logger.fine("monThread is null ");
        return true;
    }

    public boolean sendEvent(int event, boolean state) {
        if (this.fd == 0 || this.SPEventListener == null || this.monThread == null) {
            return true;
        }
        switch (event) {
            case 1: {
                logger.fine("DATA_AVAILABLE " + this.monThread.Data + ")");
                break;
            }
            case 2: {
                logger.fine("OUTPUT_BUFFER_EMPTY " + this.monThread.Output + ")");
                break;
            }
            case 3: {
                logger.fine("CTS " + this.monThread.CTS + ")");
                break;
            }
            case 4: {
                logger.fine("DSR " + this.monThread.Output + ")");
                break;
            }
            case 5: {
                logger.fine("RI " + this.monThread.RI + ")");
                break;
            }
            case 6: {
                logger.fine("CD " + this.monThread.CD + ")");
                break;
            }
            case 7: {
                logger.fine("OE " + this.monThread.OE + ")");
                break;
            }
            case 8: {
                logger.fine("PE " + this.monThread.PE + ")");
                break;
            }
            case 9: {
                logger.fine("FE " + this.monThread.FE + ")");
                break;
            }
            case 10: {
                logger.fine("BI " + this.monThread.BI + ")");
                break;
            }
            default: {
                logger.fine("XXXXXXXXXXXXXX " + event + ")");
            }
        }
        logger.fine("\tchecking flags ");
        switch (event) {
            case 1: {
                if (this.monThread.Data) break;
                return false;
            }
            case 2: {
                if (this.monThread.Output) break;
                return false;
            }
            case 3: {
                if (this.monThread.CTS) break;
                return false;
            }
            case 4: {
                if (this.monThread.DSR) break;
                return false;
            }
            case 5: {
                if (this.monThread.RI) break;
                return false;
            }
            case 6: {
                if (this.monThread.CD) break;
                return false;
            }
            case 7: {
                if (this.monThread.OE) break;
                return false;
            }
            case 8: {
                if (this.monThread.PE) break;
                return false;
            }
            case 9: {
                if (this.monThread.FE) break;
                return false;
            }
            case 10: {
                if (this.monThread.BI) break;
                return false;
            }
            default: {
                System.err.println("unknown event: " + event);
                return false;
            }
        }
        logger.fine("\tgetting event");
        SerialPortEvent e = new SerialPortEvent(this, event, !state, state);
        logger.fine("\tsending event");
        if (this.monThreadisInterrupted) {
            logger.fine("\tsendEvent return");
            return true;
        }
        if (this.SPEventListener != null) {
            this.SPEventListener.serialEvent(e);
        }
        logger.fine("\tsendEvent return");
        return this.fd == 0 || this.SPEventListener == null || this.monThread == null;
    }

    @Override
    public void addEventListener(SerialPortEventListener lsnr) throws TooManyListenersException {
        logger.fine("RXTXPort:addEventListener()");
        if (this.SPEventListener != null) {
            throw new TooManyListenersException();
        }
        this.SPEventListener = lsnr;
        if (!this.MonitorThreadAlive) {
            this.MonitorThreadLock = true;
            this.monThread = new MonitorThread();
            this.monThread.setDaemon(true);
            this.monThread.start();
            this.waitForTheNativeCodeSilly();
            this.MonitorThreadAlive = true;
        }
        logger.fine("RXTXPort:Interrupt=false");
    }

    @Override
    public void removeEventListener() {
        logger.fine("RXTXPort:removeEventListener() called");
        this.waitForTheNativeCodeSilly();
        if (this.monThreadisInterrupted) {
            logger.fine("\tRXTXPort:removeEventListener() already interrupted");
            this.monThread = null;
            this.SPEventListener = null;
            return;
        }
        if (this.monThread != null && this.monThread.isAlive()) {
            logger.fine("\tRXTXPort:Interrupt=true");
            this.monThreadisInterrupted = true;
            logger.fine("\tRXTXPort:calling interruptEventLoop");
            this.interruptEventLoop();
            logger.fine("\tRXTXPort:calling monThread.join()");
            try {
                this.monThread.join(3000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                return;
            }
            logger.fine("\tMonThread is still alive!");
        }
        this.monThread = null;
        this.SPEventListener = null;
        this.MonitorThreadLock = false;
        this.MonitorThreadAlive = false;
        this.monThreadisInterrupted = true;
        logger.fine("RXTXPort:removeEventListener() returning");
    }

    protected void waitForTheNativeCodeSilly() {
        while (this.MonitorThreadLock) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private native void nativeSetEventFlag(int var1, int var2, boolean var3);

    @Override
    public void notifyOnDataAvailable(boolean enable) {
        logger.fine("RXTXPort:notifyOnDataAvailable( " + enable + " )");
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 1, enable);
        this.monThread.Data = enable;
        this.MonitorThreadLock = false;
    }

    @Override
    public void notifyOnOutputEmpty(boolean enable) {
        logger.fine("RXTXPort:notifyOnOutputEmpty( " + enable + " )");
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 2, enable);
        this.monThread.Output = enable;
        this.MonitorThreadLock = false;
    }

    @Override
    public void notifyOnCTS(boolean enable) {
        logger.fine("RXTXPort:notifyOnCTS( " + enable + " )");
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 3, enable);
        this.monThread.CTS = enable;
        this.MonitorThreadLock = false;
    }

    @Override
    public void notifyOnDSR(boolean enable) {
        logger.fine("RXTXPort:notifyOnDSR( " + enable + " )");
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 4, enable);
        this.monThread.DSR = enable;
        this.MonitorThreadLock = false;
    }

    @Override
    public void notifyOnRingIndicator(boolean enable) {
        logger.fine("RXTXPort:notifyOnRingIndicator( " + enable + " )");
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 5, enable);
        this.monThread.RI = enable;
        this.MonitorThreadLock = false;
    }

    @Override
    public void notifyOnCarrierDetect(boolean enable) {
        logger.fine("RXTXPort:notifyOnCarrierDetect( " + enable + " )");
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 6, enable);
        this.monThread.CD = enable;
        this.MonitorThreadLock = false;
    }

    @Override
    public void notifyOnOverrunError(boolean enable) {
        logger.fine("RXTXPort:notifyOnOverrunError( " + enable + " )");
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 7, enable);
        this.monThread.OE = enable;
        this.MonitorThreadLock = false;
    }

    @Override
    public void notifyOnParityError(boolean enable) {
        logger.fine("RXTXPort:notifyOnParityError( " + enable + " )");
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 8, enable);
        this.monThread.PE = enable;
        this.MonitorThreadLock = false;
    }

    @Override
    public void notifyOnFramingError(boolean enable) {
        logger.fine("RXTXPort:notifyOnFramingError( " + enable + " )");
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 9, enable);
        this.monThread.FE = enable;
        this.MonitorThreadLock = false;
    }

    @Override
    public void notifyOnBreakInterrupt(boolean enable) {
        logger.fine("RXTXPort:notifyOnBreakInterrupt( " + enable + " )");
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 10, enable);
        this.monThread.BI = enable;
        this.MonitorThreadLock = false;
    }

    private native void nativeClose(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        RXTXPort rXTXPort = this;
        synchronized (rXTXPort) {
            logger.fine("RXTXPort:close( " + this.getName() + " )");
            while (this.IOLocked > 0) {
                logger.fine("IO is locked " + this.IOLocked);
                try {
                    this.wait(500L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            if (this.closeLock) {
                return;
            }
            this.closeLock = true;
        }
        if (this.fd <= 0) {
            logger.fine("RXTXPort:close detected bad File Descriptor");
            return;
        }
        this.setDTR(false);
        this.setDSR(false);
        logger.fine("RXTXPort:close( " + this.getName() + " ) setting monThreadisInterrupted");
        if (!this.monThreadisInterrupted) {
            this.removeEventListener();
        }
        logger.fine("RXTXPort:close( " + this.getName() + " ) calling nativeClose");
        this.nativeClose(this.getName());
        logger.fine("RXTXPort:close( " + this.getName() + " ) calling super.close");
        super.close();
        this.fd = 0;
        this.closeLock = false;
        logger.fine("RXTXPort:close( " + this.getName() + " ) leaving");
    }

    protected void finalize() {
        logger.fine("RXTXPort:finalize()");
        if (this.fd > 0) {
            logger.fine("RXTXPort:calling close()");
            this.close();
        }
    }

    public void setRcvFifoTrigger(int trigger) {
    }

    private static native void nativeStaticSetSerialPortParams(String var0, int var1, int var2, int var3, int var4) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticSetDSR(String var0, boolean var1) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticSetDTR(String var0, boolean var1) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticSetRTS(String var0, boolean var1) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticIsDSR(String var0) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticIsDTR(String var0) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticIsRTS(String var0) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticIsCTS(String var0) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticIsCD(String var0) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticIsRI(String var0) throws UnsupportedCommOperationException;

    private static native int nativeStaticGetBaudRate(String var0) throws UnsupportedCommOperationException;

    private static native int nativeStaticGetDataBits(String var0) throws UnsupportedCommOperationException;

    private static native int nativeStaticGetParity(String var0) throws UnsupportedCommOperationException;

    private static native int nativeStaticGetStopBits(String var0) throws UnsupportedCommOperationException;

    private native byte nativeGetParityErrorChar() throws UnsupportedCommOperationException;

    private native boolean nativeSetParityErrorChar(byte var1) throws UnsupportedCommOperationException;

    private native byte nativeGetEndOfInputChar() throws UnsupportedCommOperationException;

    private native boolean nativeSetEndOfInputChar(byte var1) throws UnsupportedCommOperationException;

    private native boolean nativeSetUartType(String var1, boolean var2) throws UnsupportedCommOperationException;

    native String nativeGetUartType() throws UnsupportedCommOperationException;

    private native boolean nativeSetBaudBase(int var1) throws UnsupportedCommOperationException;

    private native int nativeGetBaudBase() throws UnsupportedCommOperationException;

    private native boolean nativeSetDivisor(int var1) throws UnsupportedCommOperationException;

    private native int nativeGetDivisor() throws UnsupportedCommOperationException;

    private native boolean nativeSetLowLatency() throws UnsupportedCommOperationException;

    private native boolean nativeGetLowLatency() throws UnsupportedCommOperationException;

    private native boolean nativeSetCallOutHangup(boolean var1) throws UnsupportedCommOperationException;

    private native boolean nativeGetCallOutHangup() throws UnsupportedCommOperationException;

    private native boolean nativeClearCommInput() throws UnsupportedCommOperationException;

    public static int staticGetBaudRate(String port) throws UnsupportedCommOperationException {
        logger.fine("RXTXPort:staticGetBaudRate( " + port + " )");
        return RXTXPort.nativeStaticGetBaudRate(port);
    }

    public static int staticGetDataBits(String port) throws UnsupportedCommOperationException {
        logger.fine("RXTXPort:staticGetDataBits( " + port + " )");
        return RXTXPort.nativeStaticGetDataBits(port);
    }

    public static int staticGetParity(String port) throws UnsupportedCommOperationException {
        logger.fine("RXTXPort:staticGetParity( " + port + " )");
        return RXTXPort.nativeStaticGetParity(port);
    }

    public static int staticGetStopBits(String port) throws UnsupportedCommOperationException {
        logger.fine("RXTXPort:staticGetStopBits( " + port + " )");
        return RXTXPort.nativeStaticGetStopBits(port);
    }

    public static void staticSetSerialPortParams(String f, int b, int d, int s, int p) throws UnsupportedCommOperationException {
        logger.fine("RXTXPort:staticSetSerialPortParams( " + f + " " + b + " " + d + " " + s + " " + p);
        RXTXPort.nativeStaticSetSerialPortParams(f, b, d, s, p);
    }

    public static boolean staticSetDSR(String port, boolean flag) throws UnsupportedCommOperationException {
        logger.fine("RXTXPort:staticSetDSR( " + port + " " + flag);
        return RXTXPort.nativeStaticSetDSR(port, flag);
    }

    public static boolean staticSetDTR(String port, boolean flag) throws UnsupportedCommOperationException {
        logger.fine("RXTXPort:staticSetDTR( " + port + " " + flag);
        return RXTXPort.nativeStaticSetDTR(port, flag);
    }

    public static boolean staticSetRTS(String port, boolean flag) throws UnsupportedCommOperationException {
        logger.fine("RXTXPort:staticSetRTS( " + port + " " + flag);
        return RXTXPort.nativeStaticSetRTS(port, flag);
    }

    public static boolean staticIsRTS(String port) throws UnsupportedCommOperationException {
        logger.fine("RXTXPort:staticIsRTS( " + port + " )");
        return RXTXPort.nativeStaticIsRTS(port);
    }

    public static boolean staticIsCD(String port) throws UnsupportedCommOperationException {
        logger.fine("RXTXPort:staticIsCD( " + port + " )");
        return RXTXPort.nativeStaticIsCD(port);
    }

    public static boolean staticIsCTS(String port) throws UnsupportedCommOperationException {
        logger.fine("RXTXPort:staticIsCTS( " + port + " )");
        return RXTXPort.nativeStaticIsCTS(port);
    }

    public static boolean staticIsDSR(String port) throws UnsupportedCommOperationException {
        logger.fine("RXTXPort:staticIsDSR( " + port + " )");
        return RXTXPort.nativeStaticIsDSR(port);
    }

    public static boolean staticIsDTR(String port) throws UnsupportedCommOperationException {
        logger.fine("RXTXPort:staticIsDTR( " + port + " )");
        return RXTXPort.nativeStaticIsDTR(port);
    }

    public static boolean staticIsRI(String port) throws UnsupportedCommOperationException {
        logger.fine("RXTXPort:staticIsRI( " + port + " )");
        return RXTXPort.nativeStaticIsRI(port);
    }

    @Override
    public byte getParityErrorChar() throws UnsupportedCommOperationException {
        logger.fine("getParityErrorChar()");
        byte ret = this.nativeGetParityErrorChar();
        logger.fine("getParityErrorChar() returns " + ret);
        return ret;
    }

    @Override
    public boolean setParityErrorChar(byte b) throws UnsupportedCommOperationException {
        logger.fine("setParityErrorChar(" + b + ")");
        return this.nativeSetParityErrorChar(b);
    }

    @Override
    public byte getEndOfInputChar() throws UnsupportedCommOperationException {
        logger.fine("getEndOfInputChar()");
        byte ret = this.nativeGetEndOfInputChar();
        logger.fine("getEndOfInputChar() returns " + ret);
        return ret;
    }

    @Override
    public boolean setEndOfInputChar(byte b) throws UnsupportedCommOperationException {
        logger.fine("setEndOfInputChar(" + b + ")");
        return this.nativeSetEndOfInputChar(b);
    }

    @Override
    public boolean setUARTType(String type, boolean test) throws UnsupportedCommOperationException {
        logger.fine("RXTXPort:setUARTType()");
        return this.nativeSetUartType(type, test);
    }

    @Override
    public String getUARTType() throws UnsupportedCommOperationException {
        return this.nativeGetUartType();
    }

    @Override
    public boolean setBaudBase(int BaudBase) throws UnsupportedCommOperationException, IOException {
        logger.fine("RXTXPort:setBaudBase()");
        return this.nativeSetBaudBase(BaudBase);
    }

    @Override
    public int getBaudBase() throws UnsupportedCommOperationException, IOException {
        logger.fine("RXTXPort:getBaudBase()");
        return this.nativeGetBaudBase();
    }

    @Override
    public boolean setDivisor(int Divisor) throws UnsupportedCommOperationException, IOException {
        logger.fine("RXTXPort:setDivisor()");
        return this.nativeSetDivisor(Divisor);
    }

    @Override
    public int getDivisor() throws UnsupportedCommOperationException, IOException {
        logger.fine("RXTXPort:getDivisor()");
        return this.nativeGetDivisor();
    }

    @Override
    public boolean setLowLatency() throws UnsupportedCommOperationException {
        logger.fine("RXTXPort:setLowLatency()");
        return this.nativeSetLowLatency();
    }

    @Override
    public boolean getLowLatency() throws UnsupportedCommOperationException {
        logger.fine("RXTXPort:getLowLatency()");
        return this.nativeGetLowLatency();
    }

    @Override
    public boolean setCallOutHangup(boolean NoHup) throws UnsupportedCommOperationException {
        logger.fine("RXTXPort:setCallOutHangup()");
        return this.nativeSetCallOutHangup(NoHup);
    }

    @Override
    public boolean getCallOutHangup() throws UnsupportedCommOperationException {
        logger.fine("RXTXPort:getCallOutHangup()");
        return this.nativeGetCallOutHangup();
    }

    public boolean clearCommInput() throws UnsupportedCommOperationException {
        logger.fine("RXTXPort:clearCommInput()");
        return this.nativeClearCommInput();
    }

    class MonitorThread
    extends Thread {
        private volatile boolean CTS = false;
        private volatile boolean DSR = false;
        private volatile boolean RI = false;
        private volatile boolean CD = false;
        private volatile boolean OE = false;
        private volatile boolean PE = false;
        private volatile boolean FE = false;
        private volatile boolean BI = false;
        private volatile boolean Data = false;
        private volatile boolean Output = false;

        MonitorThread() {
        }

        @Override
        public void run() {
            logger.fine("RXTXPort:MontitorThread:run()");
            RXTXPort.this.monThreadisInterrupted = false;
            RXTXPort.this.eventLoop();
            logger.fine("eventLoop() returned");
        }
    }

    class SerialInputStream
    extends InputStream {
        SerialInputStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized int read() throws IOException {
            Object object;
            int n;
            logger.fine("RXTXPort:SerialInputStream:read() called");
            if (RXTXPort.this.fd == 0) {
                throw new IOException();
            }
            if (RXTXPort.this.monThreadisInterrupted) {
                logger.fine("+++++++++ read() monThreadisInterrupted");
            }
            Object object2 = RXTXPort.this.IOLockedMutex;
            synchronized (object2) {
                ++RXTXPort.this.IOLocked;
            }
            try {
                logger.fine("RXTXPort:SerialInputStream:read() L");
                RXTXPort.this.waitForTheNativeCodeSilly();
                logger.fine("RXTXPort:SerialInputStream:read() N");
                int result = RXTXPort.this.readByte();
                logger.fine("RXTXPort:SerialInputStream:read() returns");
                n = result;
                object = RXTXPort.this.IOLockedMutex;
            }
            catch (Throwable throwable) {
                Object object3 = RXTXPort.this.IOLockedMutex;
                synchronized (object3) {
                    --RXTXPort.this.IOLocked;
                }
                throw throwable;
            }
            synchronized (object) {
                --RXTXPort.this.IOLocked;
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized int read(byte[] b) throws IOException {
            Object object;
            int n;
            logger.fine("RXTXPort:SerialInputStream:read(" + b.length + ") called");
            if (RXTXPort.this.monThreadisInterrupted) {
                return 0;
            }
            Object object2 = RXTXPort.this.IOLockedMutex;
            synchronized (object2) {
                ++RXTXPort.this.IOLocked;
            }
            try {
                RXTXPort.this.waitForTheNativeCodeSilly();
                int result = this.read(b, 0, b.length);
                logger.fine("RXTXPort:SerialInputStream:read() returned " + result + " bytes");
                n = result;
                object = RXTXPort.this.IOLockedMutex;
            }
            catch (Throwable throwable) {
                Object object3 = RXTXPort.this.IOLockedMutex;
                synchronized (object3) {
                    --RXTXPort.this.IOLocked;
                }
                throw throwable;
            }
            synchronized (object) {
                --RXTXPort.this.IOLocked;
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized int read(byte[] b, int off, int len) throws IOException {
            Object object;
            int n;
            int a;
            if (b == null) {
                logger.fine("+++++++ NullPointerException()\n");
                logger.fine("RXTXPort:SerialInputStream:read() b == 0");
                throw new NullPointerException();
            }
            logger.fine("RXTXPort:SerialInputStream:read(" + b.length + " " + off + " " + len + ") called");
            if (RXTXPort.this.fd == 0) {
                logger.fine("RXTXPort:SerialInputStream:read() fd == 0");
                logger.fine("+++++++ IOException()\n");
                throw new IOException();
            }
            if (off < 0 || len < 0 || off + len > b.length) {
                logger.fine("+++++++ IndexOutOfBoundsException()\n");
                logger.fine("RXTXPort:SerialInputStream:read() off < 0 ..");
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                logger.fine("RXTXPort:SerialInputStream:read() off < 0 ..");
                return 0;
            }
            int Minimum = len;
            Minimum = RXTXPort.this.threshold == 0 ? ((a = RXTXPort.this.nativeavailable()) == 0 ? 1 : Math.min(Minimum, a)) : Math.min(Minimum, RXTXPort.this.threshold);
            if (RXTXPort.this.monThreadisInterrupted) {
                logger.fine("RXTXPort:SerialInputStream:read() Interrupted");
                return 0;
            }
            Object object2 = RXTXPort.this.IOLockedMutex;
            synchronized (object2) {
                ++RXTXPort.this.IOLocked;
            }
            try {
                RXTXPort.this.waitForTheNativeCodeSilly();
                int result = RXTXPort.this.readArray(b, off, Minimum);
                logger.fine("RXTXPort:SerialInputStream:read(" + b.length + " " + off + " " + len + ") returned " + result + " bytes");
                n = result;
                object = RXTXPort.this.IOLockedMutex;
            }
            catch (Throwable throwable) {
                Object object3 = RXTXPort.this.IOLockedMutex;
                synchronized (object3) {
                    --RXTXPort.this.IOLocked;
                }
                throw throwable;
            }
            synchronized (object) {
                --RXTXPort.this.IOLocked;
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized int read(byte[] b, int off, int len, byte[] t) throws IOException {
            Object object;
            int n;
            int a;
            if (b == null) {
                logger.fine("+++++++ NullPointerException()\n");
                logger.fine("RXTXPort:SerialInputStream:read() b == 0");
                throw new NullPointerException();
            }
            logger.fine("RXTXPort:SerialInputStream:read(" + b.length + " " + off + " " + len + ") called");
            if (RXTXPort.this.fd == 0) {
                logger.fine("RXTXPort:SerialInputStream:read() fd == 0");
                logger.fine("+++++++ IOException()\n");
                throw new IOException();
            }
            if (off < 0 || len < 0 || off + len > b.length) {
                logger.fine("+++++++ IndexOutOfBoundsException()\n");
                logger.fine("RXTXPort:SerialInputStream:read() off < 0 ..");
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                logger.fine("RXTXPort:SerialInputStream:read() off < 0 ..");
                return 0;
            }
            int Minimum = len;
            Minimum = RXTXPort.this.threshold == 0 ? ((a = RXTXPort.this.nativeavailable()) == 0 ? 1 : Math.min(Minimum, a)) : Math.min(Minimum, RXTXPort.this.threshold);
            if (RXTXPort.this.monThreadisInterrupted) {
                logger.fine("RXTXPort:SerialInputStream:read() Interrupted");
                return 0;
            }
            Object object2 = RXTXPort.this.IOLockedMutex;
            synchronized (object2) {
                ++RXTXPort.this.IOLocked;
            }
            try {
                RXTXPort.this.waitForTheNativeCodeSilly();
                int result = RXTXPort.this.readTerminatedArray(b, off, Minimum, t);
                logger.fine("RXTXPort:SerialInputStream:read(" + b.length + " " + off + " " + len + ") returned " + result + " bytes");
                n = result;
                object = RXTXPort.this.IOLockedMutex;
            }
            catch (Throwable throwable) {
                Object object3 = RXTXPort.this.IOLockedMutex;
                synchronized (object3) {
                    --RXTXPort.this.IOLocked;
                }
                throw throwable;
            }
            synchronized (object) {
                --RXTXPort.this.IOLocked;
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized int available() throws IOException {
            Object object;
            int n;
            if (RXTXPort.this.monThreadisInterrupted) {
                return 0;
            }
            logger.fine("RXTXPort:available() called");
            Object object2 = RXTXPort.this.IOLockedMutex;
            synchronized (object2) {
                ++RXTXPort.this.IOLocked;
            }
            try {
                int r = RXTXPort.this.nativeavailable();
                logger.fine("RXTXPort:available() returning " + r);
                n = r;
                object = RXTXPort.this.IOLockedMutex;
            }
            catch (Throwable throwable) {
                Object object3 = RXTXPort.this.IOLockedMutex;
                synchronized (object3) {
                    --RXTXPort.this.IOLocked;
                }
                throw throwable;
            }
            synchronized (object) {
                --RXTXPort.this.IOLocked;
            }
            return n;
        }
    }

    class SerialOutputStream
    extends OutputStream {
        SerialOutputStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            logger.fine("RXTXPort:SerialOutputStream:write(int)");
            if (RXTXPort.this.speed == 0) {
                return;
            }
            if (RXTXPort.this.monThreadisInterrupted) {
                return;
            }
            Object object = RXTXPort.this.IOLockedMutex;
            synchronized (object) {
                ++RXTXPort.this.IOLocked;
            }
            try {
                RXTXPort.this.waitForTheNativeCodeSilly();
                if (RXTXPort.this.fd == 0) {
                    throw new IOException();
                }
                RXTXPort.this.writeByte(b, RXTXPort.this.monThreadisInterrupted);
                logger.fine("Leaving RXTXPort:SerialOutputStream:write( int )");
            }
            catch (Throwable throwable) {
                Object object2 = RXTXPort.this.IOLockedMutex;
                synchronized (object2) {
                    --RXTXPort.this.IOLocked;
                }
                throw throwable;
            }
            Object object3 = RXTXPort.this.IOLockedMutex;
            synchronized (object3) {
                --RXTXPort.this.IOLocked;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b) throws IOException {
            logger.fine("Entering RXTXPort:SerialOutputStream:write(" + b.length + ") ");
            if (RXTXPort.this.speed == 0) {
                return;
            }
            if (RXTXPort.this.monThreadisInterrupted) {
                return;
            }
            if (RXTXPort.this.fd == 0) {
                throw new IOException();
            }
            Object object = RXTXPort.this.IOLockedMutex;
            synchronized (object) {
                ++RXTXPort.this.IOLocked;
            }
            try {
                RXTXPort.this.waitForTheNativeCodeSilly();
                RXTXPort.this.writeArray(b, 0, b.length, RXTXPort.this.monThreadisInterrupted);
                logger.fine("Leaving RXTXPort:SerialOutputStream:write(" + b.length + ")");
            }
            catch (Throwable throwable) {
                Object object2 = RXTXPort.this.IOLockedMutex;
                synchronized (object2) {
                    --RXTXPort.this.IOLocked;
                }
                throw throwable;
            }
            Object object3 = RXTXPort.this.IOLockedMutex;
            synchronized (object3) {
                --RXTXPort.this.IOLocked;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (RXTXPort.this.speed == 0) {
                return;
            }
            if (off + len > b.length) {
                throw new IndexOutOfBoundsException("Invalid offset/length passed to read");
            }
            byte[] send = new byte[len];
            System.arraycopy(b, off, send, 0, len);
            logger.fine("Entering RXTXPort:SerialOutputStream:write(" + send.length + " " + off + " " + len + " " + ") ");
            if (RXTXPort.this.fd == 0) {
                throw new IOException();
            }
            if (RXTXPort.this.monThreadisInterrupted) {
                return;
            }
            Object object = RXTXPort.this.IOLockedMutex;
            synchronized (object) {
                ++RXTXPort.this.IOLocked;
            }
            try {
                RXTXPort.this.waitForTheNativeCodeSilly();
                RXTXPort.this.writeArray(send, 0, len, RXTXPort.this.monThreadisInterrupted);
                logger.fine("Leaving RXTXPort:SerialOutputStream:write(" + send.length + " " + off + " " + len + " " + ") ");
            }
            catch (Throwable throwable) {
                Object object2 = RXTXPort.this.IOLockedMutex;
                synchronized (object2) {
                    --RXTXPort.this.IOLocked;
                }
                throw throwable;
            }
            Object object3 = RXTXPort.this.IOLockedMutex;
            synchronized (object3) {
                --RXTXPort.this.IOLocked;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            logger.fine("RXTXPort:SerialOutputStream:flush() enter");
            if (RXTXPort.this.speed == 0) {
                return;
            }
            if (RXTXPort.this.fd == 0) {
                throw new IOException();
            }
            if (RXTXPort.this.monThreadisInterrupted) {
                logger.fine("RXTXPort:SerialOutputStream:flush() Leaving Interrupted");
                return;
            }
            Object object = RXTXPort.this.IOLockedMutex;
            synchronized (object) {
                ++RXTXPort.this.IOLocked;
            }
            try {
                RXTXPort.this.waitForTheNativeCodeSilly();
                if (RXTXPort.this.nativeDrain(RXTXPort.this.monThreadisInterrupted)) {
                    RXTXPort.this.sendEvent(2, true);
                }
                logger.fine("RXTXPort:SerialOutputStream:flush() leave");
            }
            catch (Throwable throwable) {
                Object object2 = RXTXPort.this.IOLockedMutex;
                synchronized (object2) {
                    --RXTXPort.this.IOLocked;
                }
                throw throwable;
            }
            Object object3 = RXTXPort.this.IOLockedMutex;
            synchronized (object3) {
                --RXTXPort.this.IOLocked;
            }
        }
    }
}

